/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.util.StringJoiner;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.javimmutable.collections.Func2;
import org.javimmutable.collections.Proc1Throws;
import org.javimmutable.collections.Sum1Throws;
import org.javimmutable.collections.iterators.GenericIterator;
import org.javimmutable.collections.list.AbstractNode;
import org.javimmutable.collections.list.BranchNode;
import org.javimmutable.collections.list.EmptyNode;
import org.javimmutable.collections.list.MultiValueNode;

class OneValueNode<T>
extends AbstractNode<T> {
    private final T value;

    OneValueNode(T value) {
        this.value = value;
    }

    @Override
    boolean isEmpty() {
        return false;
    }

    @Override
    int size() {
        return 1;
    }

    @Override
    int depth() {
        return 0;
    }

    @Override
    T get(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.value;
    }

    @Override
    @Nonnull
    AbstractNode<T> append(T value) {
        return new MultiValueNode<T>(this.value, value);
    }

    @Override
    @Nonnull
    AbstractNode<T> append(@Nonnull AbstractNode<T> node) {
        if (node.depth() > 0) {
            return node.prepend(this);
        }
        if (node.size() == 0) {
            return this;
        }
        int combinedSize = node.size() + 1;
        if (combinedSize <= 128) {
            return new MultiValueNode<T>(this, node, combinedSize);
        }
        return new BranchNode<T>(this, node, combinedSize);
    }

    @Override
    @Nonnull
    AbstractNode<T> prepend(T value) {
        return new MultiValueNode<T>(value, this.value);
    }

    @Override
    @Nonnull
    AbstractNode<T> prepend(@Nonnull AbstractNode<T> node) {
        if (node.depth() > 0) {
            return node.append(this);
        }
        if (node.size() == 0) {
            return this;
        }
        int combinedSize = node.size() + 1;
        if (combinedSize <= 128) {
            return new MultiValueNode<T>(node, this, combinedSize);
        }
        return new BranchNode<T>(node, this, combinedSize);
    }

    @Override
    @Nonnull
    AbstractNode<T> assign(int index, T value) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        if (value == this.value) {
            return this;
        }
        return new OneValueNode<T>(value);
    }

    @Override
    @Nonnull
    AbstractNode<T> insert(int index, T value) {
        switch (index) {
            case 0: {
                return new MultiValueNode<T>(value, this.value);
            }
            case 1: {
                return new MultiValueNode<T>(this.value, value);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    AbstractNode<T> deleteFirst() {
        return EmptyNode.instance();
    }

    @Override
    @Nonnull
    AbstractNode<T> deleteLast() {
        return EmptyNode.instance();
    }

    @Override
    @Nonnull
    AbstractNode<T> delete(int index) {
        if (index == 0) {
            return EmptyNode.instance();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    AbstractNode<T> prefix(int limit) {
        switch (limit) {
            case 0: {
                return EmptyNode.instance();
            }
            case 1: {
                return this;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    AbstractNode<T> suffix(int offset) {
        switch (offset) {
            case 0: {
                return this;
            }
            case 1: {
                return EmptyNode.instance();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    AbstractNode<T> reverse() {
        return this;
    }

    @Override
    public void checkInvariants() {
    }

    @Override
    void copyTo(T[] array, int offset) {
        array[offset] = this.value;
    }

    @Override
    @Nullable
    public GenericIterator.State<T> iterateOverRange(@Nullable GenericIterator.State<T> parent, int offset, int limit) {
        return GenericIterator.singleValueState(parent, this.value);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        action.accept(this.value);
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull Proc1Throws<T, E> proc) throws E {
        proc.apply(this.value);
    }

    @Override
    public <V> V reduce(V initialValue, Func2<V, T, V> accumulator) {
        return accumulator.apply(initialValue, this.value);
    }

    @Override
    public <V, E extends Exception> V reduceThrows(V initialValue, Sum1Throws<T, V, E> accumulator) throws E {
        return accumulator.apply(initialValue, this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OneValueNode that = (OneValueNode)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return new StringJoiner(", ", OneValueNode.class.getSimpleName() + "[", "]").add("value=" + this.value).toString();
    }
}

