/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.JImmutableList;
import org.javimmutable.collections.list.JImmutableTreeList;

public final class RAListTimingComparison {
    public static void main(String[] argv) throws Exception {
        if (argv.length != 2) {
            System.err.println("usage: TimingComparison seed loops");
            System.exit(1);
        }
        long seed = Long.parseLong(argv[0]);
        int loops = Integer.parseInt(argv[1]);
        int maxCommand = 8;
        RAListTimingComparison.runTests(seed, loops, 32, 8);
        System.gc();
        Thread.sleep(500L);
        RAListTimingComparison.runTests(seed, loops, 1000, 8);
        System.gc();
        Thread.sleep(500L);
        RAListTimingComparison.runTests(seed, loops, 10000, 8);
        System.gc();
        Thread.sleep(500L);
        RAListTimingComparison.runTests(seed, loops, 100000, 8);
    }

    private static void runTests(long seed, int loops, int maxSize, int maxCommand) {
        System.out.printf("STARTING TEST WITH seed %d loops %d maxSize %d maxCommand %d%n", seed, loops, maxSize, maxCommand);
        for (int outerloop = 0; outerloop < 10; ++outerloop) {
            Random random = new Random(seed);
            int adds = 0;
            int sets = 0;
            int removes = 0;
            int gets = 0;
            long startMap = System.currentTimeMillis();
            ArrayList<Integer> expected = new ArrayList<Integer>();
            for (int i = 1; i <= loops; ++i) {
                int value;
                int index;
                int value2;
                int command = random.nextInt(maxCommand);
                if (expected.isEmpty()) {
                    value2 = random.nextInt();
                    expected.add(value2);
                    ++adds;
                    continue;
                }
                if (command <= 1) {
                    value2 = random.nextInt();
                    if (expected.size() < maxSize) {
                        expected.add(value2);
                        ++adds;
                        continue;
                    }
                    int index2 = random.nextInt(expected.size());
                    expected.set(index2, value2);
                    ++sets;
                    continue;
                }
                if (command == 2) {
                    expected.remove(expected.size() - 1);
                    ++removes;
                    continue;
                }
                if (command == 3) {
                    index = random.nextInt(expected.size());
                    value = random.nextInt();
                    expected.set(index, value);
                    ++sets;
                    continue;
                }
                if (command == 4) {
                    index = random.nextInt(expected.size());
                    expected.remove(index);
                    ++removes;
                    continue;
                }
                if (command == 5) {
                    index = random.nextInt(expected.size());
                    value = random.nextInt();
                    expected.add(index, value);
                    ++sets;
                    continue;
                }
                index = random.nextInt(expected.size());
                expected.get(index);
                ++gets;
            }
            long endMap = System.currentTimeMillis();
            System.out.printf("jlist adds %d sets %s removes %d gets %d size %d elapsed %d%n", adds, sets, removes, gets, expected.size(), endMap - startMap);
            random = new Random(seed);
            adds = 0;
            sets = 0;
            removes = 0;
            gets = 0;
            long startPer = System.currentTimeMillis();
            Insertable<Integer, JImmutableList<Integer>> list = JImmutableTreeList.of();
            for (int i = 1; i <= loops; ++i) {
                int value;
                int index;
                int value3;
                int command = random.nextInt(maxCommand);
                if (list.isEmpty()) {
                    value3 = random.nextInt();
                    list = list.insert((Object)value3);
                    ++adds;
                    continue;
                }
                if (command <= 1) {
                    value3 = random.nextInt();
                    if (list.size() < maxSize) {
                        list = list.insert((Object)value3);
                        ++adds;
                        continue;
                    }
                    int index3 = random.nextInt(list.size());
                    list = list.assign(index3, value3);
                    ++sets;
                    continue;
                }
                if (command == 2) {
                    list = list.deleteLast();
                    ++removes;
                    continue;
                }
                if (command == 3) {
                    index = random.nextInt(list.size());
                    value = random.nextInt();
                    list = list.assign(index, value);
                    ++sets;
                    continue;
                }
                if (command == 4) {
                    index = random.nextInt(list.size());
                    list = list.delete(index);
                    ++removes;
                    continue;
                }
                if (command == 5) {
                    index = random.nextInt(list.size());
                    value = random.nextInt();
                    list = list.insert(index, value);
                    ++sets;
                    continue;
                }
                index = random.nextInt(list.size());
                list.get(index);
                ++gets;
            }
            long endPer = System.currentTimeMillis();
            System.out.printf("ilist adds %d sets %d removes %d gets %d size %d elapsed %d%n", adds, sets, removes, gets, list.size(), endPer - startPer);
            Iterator expectedIterator = expected.iterator();
            Iterator listIterator = list.iterator();
            while (true) {
                RAListTimingComparison.assertEquals(expectedIterator.hasNext(), listIterator.hasNext());
                if (!expectedIterator.hasNext()) break;
                RAListTimingComparison.assertEquals((Integer)expectedIterator.next(), (Integer)listIterator.next());
            }
            System.out.println();
        }
    }

    private static void assertEquals(boolean a, boolean b) {
        if (a != b) {
            throw new RuntimeException();
        }
    }

    private static void assertEquals(Integer a, Integer b) {
        if (!a.equals(b)) {
            throw new RuntimeException();
        }
    }
}

