/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.list.AbstractNode;
import org.javimmutable.collections.list.BranchNode;
import org.javimmutable.collections.list.EmptyNode;
import org.javimmutable.collections.list.MultiValueNode;
import org.javimmutable.collections.list.OneValueNode;

@NotThreadSafe
class TreeBuilder<T> {
    private final T[] buffer = new Object[128];
    private int count;
    private int size;
    private BranchBuilder<T> parent;

    TreeBuilder() {
    }

    void clear() {
        Arrays.fill(this.buffer, null);
        this.count = 0;
        this.size = 0;
        this.parent = null;
    }

    @Nonnull
    AbstractNode<T> build() {
        AbstractNode answer;
        switch (this.count) {
            case 0: {
                answer = EmptyNode.instance();
                break;
            }
            case 1: {
                answer = new OneValueNode<T>(this.buffer[0]);
                break;
            }
            default: {
                answer = new MultiValueNode<T>(this.buffer, this.count);
            }
        }
        if (this.parent != null) {
            answer = ((BranchBuilder)this.parent).build(answer);
        }
        return answer;
    }

    int size() {
        return this.size;
    }

    void combineWith(@Nonnull TreeBuilder<T> other) {
        AbstractNode<T> a = this.build();
        AbstractNode<T> b = other.build();
        AbstractNode<T> ab = a.append(b);
        this.rebuild(ab);
    }

    void rebuild(@Nonnull AbstractNode<T> node) {
        this.count = 0;
        this.size = node.size();
        this.parent = null;
        while (node.depth() > 0) {
            this.parent = new BranchBuilder(this.parent, node.left());
            node = node.right();
        }
        for (Object t : node) {
            this.buffer[this.count++] = t;
        }
    }

    void add(T value) {
        this.buffer[this.count++] = value;
        if (this.count == 128) {
            MultiValueNode<T> leaf = new MultiValueNode<T>(this.buffer, this.count);
            if (this.parent == null) {
                this.parent = new BranchBuilder(leaf);
            } else {
                ((BranchBuilder)this.parent).add(leaf);
            }
            this.count = 0;
        }
        ++this.size;
    }

    void add(@Nonnull Iterator<? extends T> source) {
        while (source.hasNext()) {
            this.add(source.next());
        }
    }

    void add(@Nonnull Iterable<? extends T> source) {
        this.add(source.iterator());
    }

    @SafeVarargs
    final <K extends T> void add(K ... source) {
        for (K k : source) {
            this.add((T)k);
        }
    }

    void add(@Nonnull Indexed<? extends T> source, int offset, int limit) {
        for (int i = offset; i < limit; ++i) {
            this.add(source.get(i));
        }
    }

    void add(@Nonnull Indexed<? extends T> source) {
        this.add(source, 0, source.size());
    }

    @Nonnull
    static <T> AbstractNode<T> nodeFromIndexed(@Nonnull Indexed<? extends T> source) {
        return TreeBuilder.nodeFromIndexed(source, 0, source.size());
    }

    @Nonnull
    static <T> AbstractNode<T> nodeFromIndexed(@Nonnull Indexed<? extends T> source, int offset, int limit) {
        int nodeSize;
        int sourceSize = limit - offset;
        if (sourceSize == 0) {
            return EmptyNode.instance();
        }
        ArrayList nodes = new ArrayList(1 + sourceSize / 128);
        for (int o = offset; o < limit; o += nodeSize) {
            nodeSize = Math.min(128, limit - o);
            if (nodeSize == 1) {
                nodes.add(new OneValueNode<T>(source.get(o)));
                continue;
            }
            nodes.add(new MultiValueNode<T>(source.subArray(o, o + nodeSize), nodeSize));
        }
        int nodeCount = nodes.size();
        while (nodeCount > 1) {
            int writeIndex = 0;
            int readIndex = 0;
            int remaining = nodeCount;
            while (remaining > 0) {
                if (remaining > 1) {
                    nodes.set(writeIndex, BranchNode.balance((AbstractNode)nodes.get(readIndex), (AbstractNode)nodes.get(readIndex + 1)));
                    readIndex += 2;
                    ++writeIndex;
                    remaining -= 2;
                    continue;
                }
                nodes.set(writeIndex - 1, ((AbstractNode)nodes.get(writeIndex - 1)).append((AbstractNode)nodes.get(readIndex)));
                ++readIndex;
                --remaining;
            }
            nodeCount = writeIndex;
        }
        return (AbstractNode)nodes.get(0);
    }

    @Nonnull
    static <T> AbstractNode<T> nodeFromIterator(@Nonnull Iterator<? extends T> values) {
        TreeBuilder<? extends T> builder = new TreeBuilder<T>();
        builder.add(values);
        return builder.build();
    }

    void checkInvariants() {
        if (this.size != this.computeSize()) {
            throw new IllegalStateException("size mismatch");
        }
        if (this.parent != null) {
            ((BranchBuilder)this.parent).checkInvariants();
        }
    }

    private int computeSize() {
        int answer = this.count;
        if (this.parent != null) {
            answer += ((BranchBuilder)this.parent).computeSize();
        }
        return answer;
    }

    private static class BranchBuilder<T> {
        private BranchBuilder<T> parent;
        private AbstractNode<T> buffer;

        private BranchBuilder(@Nonnull BranchBuilder<T> parent, @Nonnull AbstractNode<T> node) {
            this.parent = parent;
            this.buffer = node;
        }

        private BranchBuilder(@Nonnull AbstractNode<T> node) {
            this.buffer = node;
        }

        private void add(@Nonnull AbstractNode<T> node) {
            if (this.buffer == null) {
                this.buffer = node;
            } else {
                BranchNode<T> branch = new BranchNode<T>(this.buffer, node);
                if (this.parent == null) {
                    this.parent = new BranchBuilder<T>(branch);
                } else {
                    super.add(branch);
                }
                this.buffer = null;
            }
        }

        @Nonnull
        private AbstractNode<T> build(@Nonnull AbstractNode<T> extra) {
            AbstractNode<T> answer = this.buffer == null ? extra : this.buffer.append(extra);
            if (this.parent != null) {
                answer = super.build(answer);
            }
            return answer;
        }

        private int computeSize() {
            int answer = 0;
            if (this.buffer != null) {
                answer += this.buffer.size();
            }
            if (this.parent != null) {
                answer += super.computeSize();
            }
            return answer;
        }

        private void checkInvariants() {
            if (this.buffer == null && this.parent == null) {
                throw new IllegalStateException("buffer is null");
            }
            if (this.parent != null) {
                super.checkInvariants();
            }
        }
    }
}

