/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.serialization;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.javimmutable.collections.JImmutableList;
import org.javimmutable.collections.JImmutableListMap;
import org.javimmutable.collections.JImmutableMap;

abstract class AbstractJImmutableListMapProxy
implements Externalizable {
    private static final int MAP_VERSION = 1001;
    private static final long serialVersionUID = -121805L;
    protected JImmutableListMap map;

    protected AbstractJImmutableListMapProxy(JImmutableListMap map) {
        this.map = map;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1001);
        this.writeMap(out);
        out.writeInt(this.map.size());
        for (JImmutableMap.Entry entry : this.map) {
            JImmutableList list = (JImmutableList)entry.getValue();
            out.writeObject(entry.getKey());
            out.writeInt(list.size());
            for (Object value : list) {
                out.writeObject(value);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 1001) {
            throw new IOException("unexpected version number: expected 1001 found " + version);
        }
        this.map = this.readMap(in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            int listSize = in.readInt();
            JImmutableList<Object> values = this.map.getList(key);
            for (int k = 0; k < listSize; ++k) {
                values = values.insertLast(in.readObject());
            }
            this.map = this.map.assign(key, values);
        }
    }

    protected Object readResolve() {
        return this.map;
    }

    protected JImmutableListMap readMap(ObjectInput in) throws IOException, ClassNotFoundException {
        return this.map;
    }

    protected void writeMap(ObjectOutput out) throws IOException {
    }
}

