/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.serialization;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Supplier;
import org.javimmutable.collections.JImmutableList;

abstract class AbstractJImmutableListProxy
implements Externalizable {
    private static final int LIST_VERSION = 1001;
    private static final long serialVersionUID = -121805L;
    protected final Supplier<JImmutableList.Builder> builderFactory;
    protected JImmutableList list;

    protected AbstractJImmutableListProxy(Supplier<JImmutableList.Builder> builderFactory, JImmutableList list) {
        this.builderFactory = builderFactory;
        this.list = list;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1001);
        out.writeInt(this.list.size());
        for (Object obj : this.list) {
            out.writeObject(obj);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 1001) {
            throw new IOException("unexpected version number: expected 1001 found " + version);
        }
        JImmutableList.Builder builder = this.builderFactory.get();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            builder.add(in.readObject());
        }
        this.list = builder.build();
    }

    protected Object readResolve() {
        return this.list;
    }
}

