/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.serialization;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.javimmutable.collections.JImmutableMap;

abstract class AbstractJImmutableMapProxy
implements Externalizable {
    private static final int MAP_VERSION = 1001;
    private static final long serialVersionUID = -121805L;
    protected JImmutableMap map;

    protected AbstractJImmutableMapProxy(JImmutableMap map) {
        this.map = map;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1001);
        this.writeMap(out);
        out.writeInt(this.map.size());
        for (JImmutableMap.Entry entry : this.map) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 1001) {
            throw new IOException("unexpected version number: expected 1001 found " + version);
        }
        this.map = this.readMap(in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.map = this.map.assign(key, value);
        }
    }

    protected Object readResolve() {
        return this.map;
    }

    protected JImmutableMap readMap(ObjectInput in) throws IOException, ClassNotFoundException {
        return this.map;
    }

    protected void writeMap(ObjectOutput out) throws IOException {
    }
}

