/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.serialization;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.javimmutable.collections.JImmutableSet;

abstract class AbstractJImmutableSetProxy
implements Externalizable {
    private static final int SET_VERSION = 1001;
    private static final long serialVersionUID = -121805L;
    protected JImmutableSet set;

    protected AbstractJImmutableSetProxy(JImmutableSet set) {
        this.set = set;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1001);
        this.writeSet(out);
        out.writeInt(this.set.size());
        for (Object obj : this.set) {
            out.writeObject(obj);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 1001) {
            throw new IOException("unexpected version number: expected 1001 found " + version);
        }
        this.set = this.readSet(in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.set = this.set.insert(in.readObject());
        }
    }

    protected Object readResolve() {
        return this.set;
    }

    protected JImmutableSet readSet(ObjectInput in) throws IOException, ClassNotFoundException {
        return this.set;
    }

    protected void writeSet(ObjectOutput out) throws IOException {
    }
}

