/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.serialization;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.javimmutable.collections.JImmutableArray;
import org.javimmutable.collections.array.JImmutableTrieArray;

public class JImmutableArrayProxy
implements Externalizable {
    private static final long serialVersionUID = -121805L;
    private static final int LIST_VERSION = 1001;
    private JImmutableArray<Object> list;

    public JImmutableArrayProxy() {
        this.list = JImmutableTrieArray.of();
    }

    public JImmutableArrayProxy(JImmutableArray list) {
        this.list = list;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1001);
        out.writeInt(this.list.size());
        this.list.forEachThrows(entry -> {
            out.writeInt((Integer)entry.getKey());
            out.writeObject(entry.getValue());
        });
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 1001) {
            throw new IOException("unexpected version number: expected 1001 found " + version);
        }
        int size = in.readInt();
        JImmutableArray.Builder<Object> builder = this.list.arrayBuilder();
        for (int i = 0; i < size; ++i) {
            int index = in.readInt();
            Object value = in.readObject();
            builder.put(index, value);
        }
        this.list = builder.build();
    }

    private Object readResolve() {
        return this.list;
    }
}

