/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.serialization;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.JImmutableStack;
import org.javimmutable.collections.Sequence;
import org.javimmutable.collections.list.JImmutableLinkedStack;

public class JImmutableStackProxy
implements Externalizable {
    private static final long serialVersionUID = -121805L;
    private static final int STACK_VERSION = 1001;
    private JImmutableStack list;

    public JImmutableStackProxy() {
        this.list = JImmutableLinkedStack.of();
    }

    public JImmutableStackProxy(JImmutableLinkedStack list) {
        this.list = list;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1001);
        Sequence seq = this.list;
        while (!seq.isEmpty()) {
            out.writeBoolean(true);
            out.writeObject(seq.getHead());
            seq = seq.getTail();
        }
        out.writeBoolean(false);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 1001) {
            throw new IOException("unexpected version number: expected 1001 found " + version);
        }
        Insertable seq = this.list;
        while (in.readBoolean()) {
            seq = seq.insert(in.readObject());
        }
        for (Object obj : seq) {
            this.list = this.list.insert(obj);
        }
    }

    private Object readResolve() {
        return this.list;
    }
}

