/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.setmap;

import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.JImmutableSet;
import org.javimmutable.collections.JImmutableSetMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.Conditions;
import org.javimmutable.collections.iterators.EntryIterableStreamable;

@Immutable
abstract class AbstractJImmutableSetMap<K, V>
implements JImmutableSetMap<K, V> {
    protected final JImmutableSet<V> emptySet;
    protected final JImmutableMap<K, JImmutableSet<V>> contents;

    protected AbstractJImmutableSetMap(JImmutableMap<K, JImmutableSet<V>> contents, JImmutableSet<V> emptySet) {
        this.emptySet = emptySet;
        this.contents = contents;
    }

    @Override
    @Nonnull
    public JImmutableSet<V> getSet(@Nonnull K key) {
        Conditions.stopNull(key);
        return this.contents.getValueOr(key, this.emptySet);
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> assign(@Nonnull K key, @Nonnull JImmutableSet<V> value) {
        Conditions.stopNull(key, value);
        return this.create(this.contents.assign(key, value));
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> insert(@Nonnull K key, @Nonnull V value) {
        return this.create(this.contents.update(key, h -> h.getValueOr(this.emptySet).insert((Object)value)));
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> insertAll(@Nonnull K key, @Nonnull Iterable<? extends V> values) {
        return this.insertAll(key, values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> insertAll(@Nonnull K key, @Nonnull Iterator<? extends V> values) {
        return this.create(this.contents.update(key, h -> h.getValueOr(this.emptySet).insertAll(values)));
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> getInsertableSelf() {
        return this;
    }

    @Override
    public boolean contains(@Nonnull K key) {
        return this.contents.find(key).isFilled();
    }

    @Override
    public boolean contains(@Nonnull K key, @Nullable V value) {
        return this.getSet(key).contains(value);
    }

    @Override
    public boolean containsAll(@Nonnull K key, @Nonnull Iterable<? extends V> values) {
        return this.containsAll(key, values.iterator());
    }

    @Override
    public boolean containsAll(@Nonnull K key, @Nonnull Iterator<? extends V> values) {
        return this.contains(key) && this.getSet(key).containsAll(values);
    }

    @Override
    public boolean containsAny(@Nonnull K key, @Nonnull Iterable<? extends V> values) {
        return this.containsAny(key, values.iterator());
    }

    @Override
    public boolean containsAny(@Nonnull K key, @Nonnull Iterator<? extends V> values) {
        return this.getSet(key).containsAny(values);
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> delete(@Nonnull K key) {
        return this.create(this.contents.delete(key));
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> delete(@Nonnull K key, @Nonnull V value) {
        JImmutableSet<V> set = this.getSet(key);
        return set.contains(value) ? this.create(this.contents.assign(key, set.delete(value))) : this;
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> deleteAll(@Nonnull K key, @Nonnull Iterable<? extends V> other) {
        return this.deleteAll(key, other.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> deleteAll(@Nonnull K key, @Nonnull Iterator<? extends V> other) {
        JImmutableSet<V> set = this.getSet(key);
        return set.isEmpty() ? this : this.create(this.contents.assign(key, set.deleteAll(other)));
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> union(@Nonnull K key, @Nonnull Iterable<? extends V> other) {
        return this.union(key, other.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> union(@Nonnull K key, @Nonnull Iterator<? extends V> other) {
        return this.create(this.contents.update(key, h -> h.getValueOr(this.emptySet).union(other)));
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> intersection(@Nonnull K key, @Nonnull Iterable<? extends V> other) {
        return this.intersection(key, other.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> intersection(@Nonnull K key, @Nonnull Iterator<? extends V> other) {
        return this.create(this.contents.update(key, h -> h.getValueOr(this.emptySet).intersection(other)));
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> intersection(@Nonnull K key, @Nonnull JImmutableSet<? extends V> other) {
        return this.create(this.contents.update(key, h -> h.getValueOr(this.emptySet).intersection(other)));
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> intersection(@Nonnull K key, @Nonnull Set<? extends V> other) {
        return this.create(this.contents.update(key, h -> h.getValueOr(this.emptySet).intersection(other)));
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> insert(@Nonnull JImmutableMap.Entry<K, V> e) {
        return this.insert(e.getKey(), e.getValue());
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, JImmutableSet<V>>> iterator() {
        return this.contents.iterator();
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1040;
    }

    @Override
    @Nonnull
    public IterableStreamable<K> keys() {
        return this.contents.keys();
    }

    @Override
    @Nonnull
    public IterableStreamable<V> values(@Nonnull K key) {
        return this.getSet(key);
    }

    @Override
    @Nullable
    public JImmutableSet<V> get(K key) {
        return (JImmutableSet)this.contents.get(key);
    }

    @Override
    public JImmutableSet<V> getValueOr(K key, JImmutableSet<V> defaultValue) {
        return this.contents.getValueOr(key, defaultValue);
    }

    @Override
    @Nonnull
    public Holder<JImmutableSet<V>> find(K key) {
        return this.contents.find(key);
    }

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> deleteAll() {
        return this.create(this.contents.deleteAll());
    }

    @Override
    @Nonnull
    public IterableStreamable<JImmutableMap.Entry<K, V>> entries() {
        return new EntryIterableStreamable(this);
    }

    public int hashCode() {
        return this.contents.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof AbstractJImmutableSetMap && this.contents.equals(((AbstractJImmutableSetMap)o).contents);
    }

    public String toString() {
        return this.contents.toString();
    }

    protected void checkSetMapInvariants() {
        this.contents.checkInvariants();
        for (JImmutableMap.Entry entry : this.contents) {
            ((JImmutableSet)entry.getValue()).checkInvariants();
        }
    }

    protected abstract JImmutableSetMap<K, V> create(JImmutableMap<K, JImmutableSet<V>> var1);
}

