/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.tree;

import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.Proc2;
import org.javimmutable.collections.Proc2Throws;
import org.javimmutable.collections.SplitableIterable;
import org.javimmutable.collections.Sum2;
import org.javimmutable.collections.Sum2Throws;
import org.javimmutable.collections.common.CollisionMap;
import org.javimmutable.collections.common.CollisionSet;
import org.javimmutable.collections.common.ToStringHelper;
import org.javimmutable.collections.iterators.GenericIterator;
import org.javimmutable.collections.iterators.IteratorHelper;

abstract class AbstractNode<K, V>
implements SplitableIterable<JImmutableMap.Entry<K, V>>,
GenericIterator.Iterable<JImmutableMap.Entry<K, V>>,
CollisionMap.Node,
CollisionSet.Node {
    AbstractNode() {
    }

    abstract boolean containsKey(@Nonnull Comparator<K> var1, @Nonnull K var2);

    abstract V get(@Nonnull Comparator<K> var1, @Nonnull K var2, V var3);

    @Nonnull
    abstract Holder<V> find(@Nonnull Comparator<K> var1, @Nonnull K var2);

    @Nonnull
    abstract Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull Comparator<K> var1, @Nonnull K var2);

    abstract boolean isEmpty();

    abstract int size();

    @Nonnull
    abstract AbstractNode<K, V> assign(@Nonnull Comparator<K> var1, @Nonnull K var2, @Nullable V var3);

    @Nonnull
    abstract AbstractNode<K, V> delete(@Nonnull Comparator<K> var1, @Nonnull K var2);

    @Nonnull
    abstract AbstractNode<K, V> update(@Nonnull Comparator<K> var1, @Nonnull K var2, @Nonnull Func1<Holder<V>, V> var3);

    @Nonnull
    abstract DeleteResult<K, V> deleteLeftmost();

    @Nonnull
    abstract DeleteResult<K, V> deleteRightmost();

    abstract int depth();

    @Nonnull
    abstract K key();

    @Nullable
    abstract V value();

    @Nonnull
    abstract AbstractNode<K, V> leftMost();

    @Nonnull
    abstract AbstractNode<K, V> left();

    @Nonnull
    abstract AbstractNode<K, V> right();

    abstract void checkInvariants(@Nonnull Comparator<K> var1);

    public int hashCode() {
        return IteratorHelper.iteratorHashCode(this.iterator());
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractNode && IteratorHelper.iteratorEquals(this.iterator(), ((AbstractNode)obj).iterator());
    }

    abstract void forEach(@Nonnull Proc2<K, V> var1);

    abstract <E extends Exception> void forEachThrows(@Nonnull Proc2Throws<K, V, E> var1) throws E;

    @Override
    abstract <R> R reduce(R var1, @Nonnull Sum2<K, V, R> var2);

    abstract <R, E extends Exception> R reduceThrows(R var1, @Nonnull Sum2Throws<K, V, R, E> var2) throws E;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        this.forEach((K key, V value) -> ToStringHelper.addToString(sb, 1, key, value));
        sb.append("]");
        return sb.toString();
    }

    static class DeleteResult<K, V> {
        final K key;
        final V value;
        final AbstractNode<K, V> remainder;

        DeleteResult(@Nonnull K key, V value, @Nonnull AbstractNode<K, V> remainder) {
            this.key = key;
            this.value = value;
            this.remainder = remainder;
        }

        @Nonnull
        DeleteResult<K, V> withRemainder(@Nonnull AbstractNode<K, V> remainder) {
            return new DeleteResult<K, V>(this.key, this.value, remainder);
        }
    }
}

