/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.tree;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.Proc2;
import org.javimmutable.collections.Proc2Throws;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.Sum2;
import org.javimmutable.collections.Sum2Throws;
import org.javimmutable.collections.common.AbstractJImmutableMap;
import org.javimmutable.collections.common.Conditions;
import org.javimmutable.collections.serialization.JImmutableTreeMapProxy;
import org.javimmutable.collections.tree.AbstractNode;
import org.javimmutable.collections.tree.ComparableComparator;
import org.javimmutable.collections.tree.FringeNode;
import org.javimmutable.collections.tree.TreeMapBuilder;

@Immutable
public class JImmutableTreeMap<K, V>
extends AbstractJImmutableMap<K, V>
implements Serializable {
    private static final JImmutableTreeMap EMPTY = new JImmutableTreeMap(ComparableComparator.of(), FringeNode.instance());
    private static final long serialVersionUID = -121805L;
    private final Comparator<K> comparator;
    private final AbstractNode<K, V> root;

    JImmutableTreeMap(@Nonnull Comparator<K> comparator, @Nonnull AbstractNode<K, V> root) {
        this.comparator = comparator;
        this.root = root;
    }

    @Nonnull
    public static <K extends Comparable<K>, V> JImmutableTreeMap<K, V> of() {
        return EMPTY;
    }

    @Nonnull
    public static <K, V> JImmutableTreeMap<K, V> of(@Nonnull Comparator<K> comparator) {
        return new JImmutableTreeMap(comparator, FringeNode.instance());
    }

    @Nonnull
    public static <K extends Comparable<K>, V> JImmutableMap.Builder<K, V> builder() {
        return new TreeMapBuilder(ComparableComparator.of());
    }

    @Nonnull
    public static <K, V> JImmutableMap.Builder<K, V> builder(@Nonnull Comparator<K> comparator) {
        return new TreeMapBuilder(comparator);
    }

    @Override
    @Nonnull
    public JImmutableMap.Builder<K, V> mapBuilder() {
        return new TreeMapBuilder(this.comparator);
    }

    @Nonnull
    public static <K extends Comparable<K>, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableMap<K, V>> createMapCollector() {
        return JImmutableTreeMap.createMapCollector(ComparableComparator.of());
    }

    @Nonnull
    public static <K, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableMap<K, V>> createMapCollector(@Nonnull Comparator<K> comparator) {
        return Collector.of(() -> new TreeMapBuilder(comparator), (b, v) -> b.add(v), (b1, b2) -> b1.add(b2), b -> b.build(), Collector.Characteristics.CONCURRENT);
    }

    @Override
    public V getValueOr(K key, V defaultValue) {
        Conditions.stopNull(key);
        return this.root.get(this.comparator, key, defaultValue);
    }

    @Override
    @Nonnull
    public Holder<V> find(@Nonnull K key) {
        Conditions.stopNull(key);
        return this.root.find(this.comparator, key);
    }

    @Override
    @Nonnull
    public Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull K key) {
        Conditions.stopNull(key);
        return this.root.findEntry(this.comparator, key);
    }

    @Override
    @Nonnull
    public JImmutableTreeMap<K, V> assign(@Nonnull K key, V value) {
        Conditions.stopNull(key);
        return this.create(this.root.assign(this.comparator, key, value));
    }

    @Override
    @Nonnull
    public JImmutableTreeMap<K, V> update(@Nonnull K key, @Nonnull Func1<Holder<V>, V> generator) {
        Conditions.stopNull(key);
        return this.create(this.root.update(this.comparator, key, generator));
    }

    @Override
    @Nonnull
    public JImmutableTreeMap<K, V> delete(@Nonnull K key) {
        Conditions.stopNull(key);
        AbstractNode<K, V> newRoot = this.root.delete(this.comparator, key);
        if (newRoot.isEmpty()) {
            return this.deleteAll();
        }
        return this.create(newRoot);
    }

    @Override
    public int size() {
        return this.root.size();
    }

    @Override
    @Nonnull
    public JImmutableTreeMap<K, V> deleteAll() {
        return this.comparator == ComparableComparator.of() ? EMPTY : new JImmutableTreeMap(this.comparator, FringeNode.instance());
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1040;
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator() {
        return this.root.iterator();
    }

    @Override
    public void forEach(@Nonnull Proc2<K, V> proc) {
        this.root.forEach(proc);
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull Proc2Throws<K, V, E> proc) throws E {
        this.root.forEachThrows(proc);
    }

    @Override
    public <R> R reduce(R sum, @Nonnull Sum2<K, V, R> proc) {
        return this.root.reduce(sum, proc);
    }

    @Override
    public <R, E extends Exception> R reduceThrows(R sum, @Nonnull Sum2Throws<K, V, R, E> proc) throws E {
        return this.root.reduceThrows(sum, proc);
    }

    @Override
    public void checkInvariants() {
        this.root.checkInvariants(this.comparator);
    }

    @Nonnull
    public Comparator<K> getComparator() {
        return this.comparator;
    }

    @Nonnull
    List<K> getKeysList() {
        return this.keys().stream().collect(Collectors.toList());
    }

    @Nonnull
    private JImmutableTreeMap<K, V> create(AbstractNode<K, V> newRoot) {
        if (newRoot == this.root) {
            return this;
        }
        return new JImmutableTreeMap<K, V>(this.comparator, newRoot);
    }

    private Object writeReplace() {
        return new JImmutableTreeMapProxy(this);
    }
}

