/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.tree;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.common.AbstractJImmutableMultiset;
import org.javimmutable.collections.serialization.JImmutableTreeMultisetProxy;
import org.javimmutable.collections.tree.ComparableComparator;
import org.javimmutable.collections.tree.JImmutableTreeMap;

@Immutable
public class JImmutableTreeMultiset<T>
extends AbstractJImmutableMultiset<T>
implements Serializable {
    private static final JImmutableTreeMultiset EMPTY = new JImmutableTreeMultiset(new ComparableComparator());
    private final Comparator<T> comparator;

    private JImmutableTreeMultiset(Comparator<T> comparator) {
        this(JImmutableTreeMap.of(comparator), 0, comparator);
    }

    private JImmutableTreeMultiset(JImmutableMap<T, Integer> map, int occurrences, Comparator<T> comparator) {
        super(map, occurrences);
        this.comparator = comparator;
    }

    @Override
    @Nonnull
    public JImmutableTreeMultiset<T> deleteAll() {
        return JImmutableTreeMultiset.of(this.comparator);
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public static <T extends Comparable<T>> JImmutableTreeMultiset<T> of() {
        return EMPTY;
    }

    public static <T> JImmutableTreeMultiset<T> of(Comparator<T> comparator) {
        return new JImmutableTreeMultiset<T>(comparator);
    }

    @Override
    protected JImmutableTreeMultiset<T> create(JImmutableMap<T, Integer> map, int occurrences) {
        return new JImmutableTreeMultiset<T>(map, occurrences, this.comparator);
    }

    @Override
    protected Map<T, Integer> emptyMutableMap() {
        return new TreeMap(this.comparator);
    }

    JImmutableMap getMap() {
        return this.map;
    }

    private Object writeReplace() {
        return new JImmutableTreeMultisetProxy(this);
    }
}

