/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.tree;

import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.Proc2;
import org.javimmutable.collections.Proc2Throws;
import org.javimmutable.collections.Sum2;
import org.javimmutable.collections.Sum2Throws;
import org.javimmutable.collections.iterators.GenericIterator;
import org.javimmutable.collections.tree.AbstractNode;
import org.javimmutable.collections.tree.FringeNode;
import org.javimmutable.collections.tree.ValueNode;

public class LeafNode<K, V>
extends AbstractNode<K, V> {
    private final K key;
    private final V value;

    LeafNode(@Nonnull K key, @Nullable V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    boolean containsKey(@Nonnull Comparator<K> comp, @Nonnull K key) {
        return this.isMatch(comp, key);
    }

    @Override
    V get(@Nonnull Comparator<K> comp, @Nonnull K key, V defaultValue) {
        return this.isMatch(comp, key) ? this.value : defaultValue;
    }

    @Override
    @Nonnull
    Holder<V> find(@Nonnull Comparator<K> comp, @Nonnull K key) {
        if (this.isMatch(comp, key)) {
            return Holders.of(this.value);
        }
        return Holders.of();
    }

    @Override
    @Nonnull
    Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull Comparator<K> comp, @Nonnull K key) {
        if (this.isMatch(comp, key)) {
            return Holders.of(this.asEntry());
        }
        return Holders.of();
    }

    @Override
    boolean isEmpty() {
        return false;
    }

    @Override
    int size() {
        return 1;
    }

    @Override
    @Nonnull
    AbstractNode<K, V> assign(@Nonnull Comparator<K> comp, @Nonnull K key, @Nullable V value) {
        if (this.isMatch(comp, key)) {
            if (this.value == value) {
                return this;
            }
            return new LeafNode<K, V>(key, value);
        }
        return ValueNode.instance(comp, this.key, this.value, key, value);
    }

    @Override
    @Nonnull
    AbstractNode<K, V> delete(@Nonnull Comparator<K> comp, @Nonnull K key) {
        if (this.isMatch(comp, key)) {
            return FringeNode.instance();
        }
        return this;
    }

    @Override
    @Nonnull
    AbstractNode<K, V> update(@Nonnull Comparator<K> comp, @Nonnull K key, @Nonnull Func1<Holder<V>, V> generator) {
        if (this.isMatch(comp, key)) {
            V value = generator.apply(Holders.of(this.value));
            if (this.value == value) {
                return this;
            }
            return new LeafNode<K, V>(key, value);
        }
        V value = generator.apply(Holders.of());
        return ValueNode.instance(comp, this.key, this.value, key, value);
    }

    @Override
    @Nonnull
    AbstractNode.DeleteResult<K, V> deleteLeftmost() {
        return new AbstractNode.DeleteResult<K, V>(this.key, this.value, FringeNode.instance());
    }

    @Override
    @Nonnull
    AbstractNode.DeleteResult<K, V> deleteRightmost() {
        return new AbstractNode.DeleteResult<K, V>(this.key, this.value, FringeNode.instance());
    }

    @Override
    int depth() {
        return 1;
    }

    @Override
    @Nonnull
    K key() {
        return this.key;
    }

    @Override
    @Nullable
    V value() {
        return this.value;
    }

    @Override
    @Nonnull
    AbstractNode<K, V> leftMost() {
        return this;
    }

    @Override
    @Nonnull
    AbstractNode<K, V> left() {
        return FringeNode.instance();
    }

    @Override
    @Nonnull
    AbstractNode<K, V> right() {
        return FringeNode.instance();
    }

    @Override
    void checkInvariants(@Nonnull Comparator<K> comp) {
    }

    @Override
    void forEach(@Nonnull Proc2<K, V> proc) {
        proc.apply(this.key, this.value);
    }

    @Override
    <E extends Exception> void forEachThrows(@Nonnull Proc2Throws<K, V, E> proc) throws E {
        proc.apply(this.key, this.value);
    }

    @Override
    <R> R reduce(R sum, @Nonnull Sum2<K, V, R> proc) {
        return proc.apply(sum, this.key, this.value);
    }

    @Override
    <R, E extends Exception> R reduceThrows(R sum, @Nonnull Sum2Throws<K, V, R, E> proc) throws E {
        return proc.apply(sum, this.key, this.value);
    }

    @Override
    @Nullable
    public GenericIterator.State<JImmutableMap.Entry<K, V>> iterateOverRange(@Nullable GenericIterator.State<JImmutableMap.Entry<K, V>> parent, int offset, int limit) {
        return GenericIterator.singleValueState(parent, this.asEntry());
    }

    @Override
    public int iterableSize() {
        return 1;
    }

    private boolean isMatch(@Nonnull Comparator<K> comp, @Nonnull K key) {
        return comp.compare(key, this.key) == 0;
    }

    private JImmutableMap.Entry<K, V> asEntry() {
        return MapEntry.entry(this.key, this.value);
    }
}

