/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.tree;

import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.tree.JImmutableTreeMap;

public final class TimingComparison {
    private TimingComparison() {
    }

    public static void main(String[] argv) {
        if (argv.length != 2) {
            System.err.println("usage: TimingComparison seed loops");
            System.exit(1);
        }
        int seed = Integer.parseInt(argv[0]);
        int loops = Integer.parseInt(argv[1]);
        int maxValue = 10 * loops;
        int maxKey = 999999999;
        int maxCommand = 6;
        for (int i = 0; i < 20; ++i) {
            TimingComparison.runLoop(seed + i, loops, maxValue, 999999999, 6);
            System.out.println();
        }
    }

    private static void runLoop(int seed, int loops, int maxValue, int maxKey, int maxCommand) {
        Random random = new Random(seed);
        int adds = 0;
        int removes = 0;
        int gets = 0;
        long startMap = System.currentTimeMillis();
        TreeMap<Integer, Integer> expected = new TreeMap<Integer, Integer>();
        for (int i = 1; i <= loops; ++i) {
            Integer key;
            int command = random.nextInt(maxCommand);
            if (command <= 1) {
                key = random.nextInt(maxKey);
                Integer value = random.nextInt(maxValue);
                expected.put(key, value);
                ++adds;
                continue;
            }
            if (command == 2) {
                key = random.nextInt(maxKey);
                expected.remove(key);
                ++removes;
                continue;
            }
            key = random.nextInt(maxKey);
            expected.get(key);
            ++gets;
        }
        long endMap = System.currentTimeMillis();
        System.out.printf("map adds %d removes %d gets %d size %d elapsed %d%n", adds, removes, gets, expected.size(), endMap - startMap);
        random = new Random(seed);
        adds = 0;
        removes = 0;
        gets = 0;
        long startPer = System.currentTimeMillis();
        JImmutableMap<Object, Object> map = JImmutableTreeMap.of();
        for (int i = 1; i <= loops; ++i) {
            Integer key;
            int command = random.nextInt(maxCommand);
            if (command <= 1) {
                key = random.nextInt(maxKey);
                Integer value = random.nextInt(maxValue);
                map = map.assign(key, value);
                ++adds;
                continue;
            }
            if (command == 2) {
                key = random.nextInt(maxKey);
                map = map.delete(key);
                ++removes;
                continue;
            }
            key = random.nextInt(maxKey);
            map.find(key);
            ++gets;
        }
        long endPer = System.currentTimeMillis();
        System.out.printf("tree adds %d removes %d gets %d size %d elapsed %d%n", adds, removes, gets, expected.size(), endPer - startPer);
        map.checkInvariants();
        Iterator expectedIter = expected.entrySet().iterator();
        Iterator mapIter = map.iterator();
        while (expectedIter.hasNext()) {
            if (!mapIter.hasNext()) {
                throw new RuntimeException();
            }
            Map.Entry expectedEntry = expectedIter.next();
            JImmutableMap.Entry mapEntry = (JImmutableMap.Entry)mapIter.next();
            TimingComparison.assertEquals((Integer)expectedEntry.getKey(), (Integer)mapEntry.getKey());
            TimingComparison.assertEquals((Integer)expectedEntry.getValue(), (Integer)mapEntry.getValue());
        }
    }

    private static void assertEquals(Integer a, Integer b) {
        if (!a.equals(b)) {
            throw new RuntimeException();
        }
    }
}

