/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.tree;

import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.Proc2;
import org.javimmutable.collections.Proc2Throws;
import org.javimmutable.collections.Sum2;
import org.javimmutable.collections.Sum2Throws;
import org.javimmutable.collections.common.CollisionMap;
import org.javimmutable.collections.iterators.GenericIterator;
import org.javimmutable.collections.tree.AbstractNode;
import org.javimmutable.collections.tree.ComparableComparator;
import org.javimmutable.collections.tree.FringeNode;
import org.javimmutable.collections.tree.ValueNode;

@Immutable
public class TreeCollisionMap<K, V>
implements CollisionMap<K, V> {
    private static final TreeCollisionMap EMPTY = new TreeCollisionMap(ComparableComparator.of());
    private final Comparator<K> comparator;

    private TreeCollisionMap(@Nonnull Comparator<K> comparator) {
        this.comparator = comparator;
    }

    public static <K, V> TreeCollisionMap<K, V> instance() {
        return EMPTY;
    }

    private AbstractNode<K, V> root(@Nonnull CollisionMap.Node node) {
        return (AbstractNode)node;
    }

    @Override
    @Nonnull
    public CollisionMap.Node empty() {
        return FringeNode.instance();
    }

    @Override
    @Nonnull
    public CollisionMap.Node single(@Nonnull K key, @Nullable V value) {
        return ValueNode.instance(key, value);
    }

    @Override
    @Nonnull
    public CollisionMap.Node dual(@Nonnull K key1, @Nullable V value1, @Nonnull K key2, @Nullable V value2) {
        return ValueNode.instance(this.comparator, key1, value1, key2, value2);
    }

    @Override
    public int size(@Nonnull CollisionMap.Node node) {
        return this.root(node).size();
    }

    @Override
    @Nonnull
    public CollisionMap.Node update(@Nonnull CollisionMap.Node node, @Nonnull K key, @Nullable V value) {
        return this.root(node).assign(this.comparator, key, value);
    }

    @Override
    @Nonnull
    public CollisionMap.Node update(@Nonnull CollisionMap.Node node, @Nonnull K key, @Nonnull Func1<Holder<V>, V> generator) {
        return this.root(node).update(this.comparator, key, generator);
    }

    @Override
    @Nonnull
    public CollisionMap.Node delete(@Nonnull CollisionMap.Node node, @Nonnull K key) {
        return this.root(node).delete(this.comparator, key);
    }

    @Override
    public V getValueOr(@Nonnull CollisionMap.Node node, @Nonnull K key, V defaultValue) {
        return this.root(node).get(this.comparator, key, defaultValue);
    }

    @Override
    @Nonnull
    public Holder<V> findValue(@Nonnull CollisionMap.Node node, @Nonnull K key) {
        return this.root(node).find(this.comparator, key);
    }

    @Override
    @Nonnull
    public Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull CollisionMap.Node node, @Nonnull K key) {
        return this.root(node).findEntry(this.comparator, key);
    }

    @Override
    @Nonnull
    public JImmutableMap.Entry<K, V> first(@Nonnull CollisionMap.Node node) {
        AbstractNode<K, V> first = this.root(node).leftMost();
        return MapEntry.entry(first.key(), first.value());
    }

    @Override
    @Nullable
    public GenericIterator.State<JImmutableMap.Entry<K, V>> iterateOverRange(@Nonnull CollisionMap.Node node, @Nullable GenericIterator.State<JImmutableMap.Entry<K, V>> parent, int offset, int limit) {
        return this.root(node).iterateOverRange(parent, offset, limit);
    }

    @Override
    public void forEach(@Nonnull CollisionMap.Node node, @Nonnull Proc2<K, V> proc) {
        this.root(node).forEach(proc);
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull CollisionMap.Node node, @Nonnull Proc2Throws<K, V, E> proc) throws E {
        this.root(node).forEachThrows(proc);
    }

    @Override
    public <R> R reduce(@Nonnull CollisionMap.Node node, R sum, @Nonnull Sum2<K, V, R> proc) {
        return this.root(node).reduce(sum, proc);
    }

    @Override
    public <R, E extends Exception> R reduceThrows(@Nonnull CollisionMap.Node node, R sum, @Nonnull Sum2Throws<K, V, R, E> proc) throws E {
        return this.root(node).reduceThrows(sum, proc);
    }
}

