/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.tree;

import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Proc1;
import org.javimmutable.collections.Proc1Throws;
import org.javimmutable.collections.Sum1;
import org.javimmutable.collections.Sum1Throws;
import org.javimmutable.collections.common.CollisionSet;
import org.javimmutable.collections.iterators.GenericIterator;
import org.javimmutable.collections.tree.AbstractNode;
import org.javimmutable.collections.tree.ComparableComparator;
import org.javimmutable.collections.tree.FringeNode;
import org.javimmutable.collections.tree.ValueNode;

@Immutable
public class TreeCollisionSet<T>
implements CollisionSet<T> {
    private static final TreeCollisionSet EMPTY = new TreeCollisionSet(ComparableComparator.of());
    private final Comparator<T> comparator;

    private TreeCollisionSet(@Nonnull Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public static <T> TreeCollisionSet<T> instance() {
        return EMPTY;
    }

    private AbstractNode<T, Boolean> root(@Nonnull CollisionSet.Node node) {
        return (AbstractNode)node;
    }

    @Override
    @Nonnull
    public CollisionSet.Node empty() {
        return FringeNode.instance();
    }

    @Override
    @Nonnull
    public CollisionSet.Node single(@Nonnull T value) {
        return ValueNode.instance(value, Boolean.TRUE);
    }

    @Override
    @Nonnull
    public CollisionSet.Node dual(@Nonnull T value1, @Nonnull T value2) {
        return ValueNode.instance(this.comparator, value1, Boolean.TRUE, value2, Boolean.TRUE);
    }

    @Override
    public int size(@Nonnull CollisionSet.Node node) {
        return this.root(node).size();
    }

    @Override
    public boolean contains(@Nonnull CollisionSet.Node node, @Nonnull T value) {
        return this.root(node).containsKey(this.comparator, value);
    }

    @Override
    @Nonnull
    public CollisionSet.Node insert(@Nonnull CollisionSet.Node node, @Nonnull T value) {
        return this.root(node).assign(this.comparator, value, Boolean.TRUE);
    }

    @Override
    @Nonnull
    public CollisionSet.Node delete(@Nonnull CollisionSet.Node node, @Nonnull T value) {
        return this.root(node).delete(this.comparator, value);
    }

    @Override
    @Nonnull
    public T first(@Nonnull CollisionSet.Node node) {
        return this.root(node).leftMost().key();
    }

    @Override
    @Nullable
    public GenericIterator.State<T> iterateOverRange(@Nonnull CollisionSet.Node node, @Nullable GenericIterator.State<T> parent, int offset, int limit) {
        return GenericIterator.transformState(parent, this.root(node).iterateOverRange(null, offset, limit), e -> e.getKey());
    }

    @Override
    public void forEach(@Nonnull CollisionSet.Node node, @Nonnull Proc1<T> proc) {
        this.root(node).forEach((k, v) -> proc.apply(k));
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull CollisionSet.Node node, @Nonnull Proc1Throws<T, E> proc) throws E {
        this.root(node).forEachThrows((k, v) -> proc.apply(k));
    }

    @Override
    public <R> R reduce(@Nonnull CollisionSet.Node node, R sum, @Nonnull Sum1<T, R> proc) {
        return (R)this.root(node).reduce(sum, (s, k, v) -> proc.apply(s, k));
    }

    @Override
    public <R, E extends Exception> R reduceThrows(@Nonnull CollisionSet.Node node, R sum, @Nonnull Sum1Throws<T, R, E> proc) throws E {
        return (R)this.root(node).reduceThrows(sum, (s, k, v) -> proc.apply(s, k));
    }
}

