/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.tree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.tree.AbstractNode;
import org.javimmutable.collections.tree.FringeNode;
import org.javimmutable.collections.tree.JImmutableTreeMap;
import org.javimmutable.collections.tree.ValueNode;

@ThreadSafe
class TreeMapBuilder<K, V>
implements JImmutableMap.Builder<K, V> {
    private final Comparator<K> comparator;
    private final Map<K, V> values;

    TreeMapBuilder(@Nonnull Comparator<K> comparator) {
        this.comparator = comparator;
        this.values = new TreeMap(comparator);
    }

    @Override
    @Nonnull
    public synchronized JImmutableMap<K, V> build() {
        if (this.values.isEmpty()) {
            return JImmutableTreeMap.of(this.comparator);
        }
        ArrayList<Map.Entry<K, V>> sorted = new ArrayList<Map.Entry<K, V>>(this.values.entrySet());
        AbstractNode<K, V> root = this.buildTree(sorted, 0, sorted.size());
        return new JImmutableTreeMap<K, V>(this.comparator, root);
    }

    @Override
    @Nonnull
    public synchronized JImmutableMap.Builder<K, V> clear() {
        this.values.clear();
        return this;
    }

    @Override
    @Nonnull
    public synchronized JImmutableMap.Builder<K, V> add(@Nonnull K key, V value) {
        this.values.put(key, value);
        return this;
    }

    @Override
    public synchronized int size() {
        return this.values.size();
    }

    private AbstractNode<K, V> buildTree(@Nonnull List<Map.Entry<K, V>> values, int offset, int limit) {
        assert (limit > offset);
        int count = limit - offset;
        if (count == 1) {
            Map.Entry<K, V> e = values.get(offset);
            return ValueNode.instance(e.getKey(), e.getValue());
        }
        if (count == 2) {
            Map.Entry<K, V> a = values.get(offset);
            Map.Entry<K, V> b = values.get(offset + 1);
            AbstractNode<K, V> right = ValueNode.instance(b.getKey(), b.getValue());
            return new ValueNode<K, V>(a.getKey(), a.getValue(), FringeNode.instance(), right);
        }
        int middle = offset + count / 2;
        Map.Entry<K, V> e = values.get(middle);
        AbstractNode<K, V> left = this.buildTree(values, offset, middle);
        AbstractNode<K, V> right = this.buildTree(values, middle + 1, limit);
        return new ValueNode<K, V>(e.getKey(), e.getValue(), left, right);
    }
}

