/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.tree;

import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.Proc2;
import org.javimmutable.collections.Proc2Throws;
import org.javimmutable.collections.Sum2;
import org.javimmutable.collections.Sum2Throws;
import org.javimmutable.collections.indexed.IndexedHelper;
import org.javimmutable.collections.iterators.GenericIterator;
import org.javimmutable.collections.tree.AbstractNode;
import org.javimmutable.collections.tree.FringeNode;
import org.javimmutable.collections.tree.LeafNode;

@Immutable
class ValueNode<K, V>
extends AbstractNode<K, V> {
    private final K key;
    private final V value;
    private final AbstractNode<K, V> left;
    private final AbstractNode<K, V> right;
    private final int depth;
    private final int size;

    ValueNode(@Nonnull K key, @Nullable V value, @Nonnull AbstractNode<K, V> left, @Nonnull AbstractNode<K, V> right) {
        this.key = key;
        this.value = value;
        this.left = left;
        this.right = right;
        this.depth = 1 + Math.max(left.depth(), right.depth());
        this.size = 1 + left.size() + right.size();
    }

    static <K, V> AbstractNode<K, V> instance(K key, V value) {
        return new LeafNode<K, V>(key, value);
    }

    static <K, V> AbstractNode<K, V> instance(K key, V value, AbstractNode<K, V> left, AbstractNode<K, V> right) {
        if (left.isEmpty() && right.isEmpty()) {
            return new LeafNode<K, V>(key, value);
        }
        return new ValueNode<K, V>(key, value, left, right);
    }

    static <K, V> AbstractNode<K, V> instance(@Nonnull Comparator<K> comp, @Nonnull K key1, @Nullable V value1, @Nonnull K key2, @Nullable V value2) {
        int diff = comp.compare(key1, key2);
        if (diff == 0) {
            return ValueNode.instance(key1, value2);
        }
        if (diff < 0) {
            return new ValueNode<K, V>(key1, value1, FringeNode.instance(), ValueNode.instance(key2, value2));
        }
        return new ValueNode<K, V>(key1, value1, ValueNode.instance(key2, value2), FringeNode.instance());
    }

    static <K, V> AbstractNode<K, V> balance(@Nonnull K key, @Nullable V value, @Nonnull AbstractNode<K, V> left, @Nonnull AbstractNode<K, V> right) {
        int diff = left.depth() - right.depth();
        if (diff < -1) {
            return ValueNode.rotateLeft(key, value, left, right);
        }
        if (diff > 1) {
            return ValueNode.rotateRight(key, value, left, right);
        }
        return ValueNode.instance(key, value, left, right);
    }

    @Nonnull
    private static <K, V> AbstractNode<K, V> rotateRight(@Nonnull K key, @Nullable V value, @Nonnull AbstractNode<K, V> left, @Nonnull AbstractNode<K, V> right) {
        left = ValueNode.ensureLeftBranchTaller(left);
        ValueNode<K, V> newRight = new ValueNode<K, V>(key, value, left.right(), right);
        return ValueNode.instance(left.key(), left.value(), left.left(), newRight);
    }

    @Nonnull
    private static <K, V> AbstractNode<K, V> rotateLeft(@Nonnull K key, @Nullable V value, @Nonnull AbstractNode<K, V> left, @Nonnull AbstractNode<K, V> right) {
        right = ValueNode.ensureRightBranchTaller(right);
        ValueNode<K, V> newLeft = new ValueNode<K, V>(key, value, left, right.left());
        return ValueNode.instance(right.key(), right.value(), newLeft, right.right());
    }

    @Nonnull
    private static <K, V> AbstractNode<K, V> ensureLeftBranchTaller(@Nonnull AbstractNode<K, V> node) {
        AbstractNode<K, V> left = node.left();
        AbstractNode<K, V> right = node.right();
        if (right.depth() > left.depth()) {
            ValueNode<K, V> newLeft = new ValueNode<K, V>(node.key(), node.value(), left, right.left());
            node = ValueNode.instance(right.key(), right.value(), newLeft, right.right());
        }
        return node;
    }

    @Nonnull
    private static <K, V> AbstractNode<K, V> ensureRightBranchTaller(@Nonnull AbstractNode<K, V> node) {
        AbstractNode<K, V> left = node.left();
        AbstractNode<K, V> right = node.right();
        if (left.depth() > right.depth()) {
            ValueNode<K, V> newRight = new ValueNode<K, V>(node.key(), node.value(), left.right(), right);
            node = ValueNode.instance(left.key(), left.value(), left.left(), newRight);
        }
        return node;
    }

    @Override
    @Nonnull
    public AbstractNode<K, V> assign(@Nonnull Comparator<K> comp, @Nonnull K key, @Nullable V value) {
        K thisKey = this.key;
        V thisValue = this.value;
        AbstractNode<K, V> left = this.left;
        AbstractNode<K, V> right = this.right;
        int diff = comp.compare(key, thisKey);
        if (diff == 0) {
            if (value != thisValue) {
                return new ValueNode<K, V>(key, value, left, right);
            }
        } else if (diff < 0) {
            AbstractNode<K, V> newLeft = left.assign(comp, key, value);
            if (newLeft != left) {
                return ValueNode.balance(thisKey, thisValue, newLeft, right);
            }
        } else {
            AbstractNode<K, V> newRight = right.assign(comp, key, value);
            if (newRight != right) {
                return ValueNode.balance(thisKey, thisValue, left, newRight);
            }
        }
        return this;
    }

    @Override
    @Nonnull
    public AbstractNode<K, V> update(@Nonnull Comparator<K> comp, @Nonnull K key, @Nonnull Func1<Holder<V>, V> generator) {
        K thisKey = this.key;
        V thisValue = this.value;
        AbstractNode<K, V> left = this.left;
        AbstractNode<K, V> right = this.right;
        int diff = comp.compare(key, thisKey);
        if (diff == 0) {
            V newValue = generator.apply(Holders.of(thisValue));
            if (newValue != thisValue) {
                return new ValueNode<K, V>(key, newValue, left, right);
            }
        } else if (diff < 0) {
            AbstractNode<K, V> newLeft = left.update(comp, key, generator);
            if (newLeft != left) {
                return ValueNode.balance(thisKey, thisValue, newLeft, right);
            }
        } else {
            AbstractNode<K, V> newRight = right.update(comp, key, generator);
            if (newRight != right) {
                return ValueNode.balance(thisKey, thisValue, left, newRight);
            }
        }
        return this;
    }

    @Override
    @Nonnull
    public AbstractNode<K, V> delete(@Nonnull Comparator<K> comp, @Nonnull K key) {
        K thisKey = this.key;
        V thisValue = this.value;
        AbstractNode<K, V> left = this.left;
        AbstractNode<K, V> right = this.right;
        int diff = comp.compare(key, thisKey);
        if (diff == 0) {
            if (left.isEmpty()) {
                return right;
            }
            if (right.isEmpty()) {
                return left;
            }
            if (left.depth() > right.depth()) {
                AbstractNode.DeleteResult<K, V> result = left.deleteRightmost();
                return ValueNode.balance(result.key, result.value, result.remainder, right);
            }
            AbstractNode.DeleteResult<K, V> result = right.deleteLeftmost();
            return ValueNode.balance(result.key, result.value, left, result.remainder);
        }
        if (diff < 0) {
            AbstractNode<K, V> newLeft = left.delete(comp, key);
            if (newLeft != left) {
                return ValueNode.balance(thisKey, thisValue, newLeft, right);
            }
        } else {
            AbstractNode<K, V> newRight = right.delete(comp, key);
            if (newRight != right) {
                return ValueNode.balance(thisKey, thisValue, left, newRight);
            }
        }
        return this;
    }

    @Override
    @Nonnull
    AbstractNode.DeleteResult<K, V> deleteLeftmost() {
        if (this.left.isEmpty()) {
            return new AbstractNode.DeleteResult<K, V>(this.key, this.value, this.right);
        }
        AbstractNode.DeleteResult<K, V> result = this.left.deleteLeftmost();
        return result.withRemainder(ValueNode.balance(this.key, this.value, result.remainder, this.right));
    }

    @Override
    @Nonnull
    AbstractNode.DeleteResult<K, V> deleteRightmost() {
        if (this.right.isEmpty()) {
            return new AbstractNode.DeleteResult<K, V>(this.key, this.value, this.left);
        }
        AbstractNode.DeleteResult<K, V> result = this.right.deleteRightmost();
        return result.withRemainder(ValueNode.balance(this.key, this.value, this.left, result.remainder));
    }

    @Override
    boolean containsKey(@Nonnull Comparator<K> comp, @Nonnull K key) {
        int diff = comp.compare(key, this.key);
        if (diff == 0) {
            return true;
        }
        if (diff < 0) {
            return this.left.containsKey(comp, key);
        }
        return this.right.containsKey(comp, key);
    }

    @Override
    @Nullable
    public V get(@Nonnull Comparator<K> comp, @Nonnull K key, V defaultValue) {
        int diff = comp.compare(key, this.key);
        if (diff == 0) {
            return this.value;
        }
        if (diff < 0) {
            return this.left.get(comp, key, defaultValue);
        }
        return this.right.get(comp, key, defaultValue);
    }

    @Override
    @Nonnull
    public Holder<V> find(@Nonnull Comparator<K> comp, @Nonnull K key) {
        int diff = comp.compare(key, this.key);
        if (diff == 0) {
            return Holders.of(this.value);
        }
        if (diff < 0) {
            return this.left.find(comp, key);
        }
        return this.right.find(comp, key);
    }

    @Override
    @Nonnull
    public Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull Comparator<K> comp, @Nonnull K key) {
        int diff = comp.compare(key, this.key);
        if (diff == 0) {
            return Holders.of(this.entry());
        }
        if (diff < 0) {
            return this.left.findEntry(comp, key);
        }
        return this.right.findEntry(comp, key);
    }

    private JImmutableMap.Entry<K, V> entry() {
        return MapEntry.of(this.key, this.value);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    int depth() {
        return this.depth;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @Nonnull
    K key() {
        return this.key;
    }

    @Override
    @Nullable
    V value() {
        return this.value;
    }

    @Override
    @Nonnull
    AbstractNode<K, V> leftMost() {
        if (this.left.isEmpty()) {
            if (this.right.isEmpty()) {
                return this;
            }
            return this.right.leftMost();
        }
        return this.left.leftMost();
    }

    @Override
    @Nonnull
    AbstractNode<K, V> left() {
        return this.left;
    }

    @Override
    @Nonnull
    AbstractNode<K, V> right() {
        return this.right;
    }

    @Override
    public void checkInvariants(@Nonnull Comparator<K> comp) {
        if (this.key == null) {
            throw new IllegalStateException();
        }
        if (this.left.size() > 0 && comp.compare(this.left.key(), this.key) >= 0) {
            throw new IllegalStateException();
        }
        if (this.right.size() > 0 && comp.compare(this.right.key(), this.key) <= 0) {
            throw new IllegalStateException();
        }
        if (Math.abs(this.left.depth() - this.right.depth()) > 1) {
            throw new IllegalStateException();
        }
        if (this.depth != 1 + Math.max(this.left.depth(), this.right.depth())) {
            throw new IllegalStateException();
        }
        if (this.size != 1 + this.left.size() + this.right.size()) {
            throw new IllegalStateException();
        }
        this.left.checkInvariants(comp);
        this.right.checkInvariants(comp);
    }

    @Override
    @Nullable
    public GenericIterator.State<JImmutableMap.Entry<K, V>> iterateOverRange(@Nullable GenericIterator.State<JImmutableMap.Entry<K, V>> parent, int offset, int limit) {
        assert (offset >= 0 && limit <= this.size && offset <= limit);
        return GenericIterator.multiIterableState(parent, IndexedHelper.indexed(this.left, GenericIterator.singleValueIterable(MapEntry.of(this.key, this.value)), this.right), offset, limit);
    }

    @Override
    public int iterableSize() {
        return this.size;
    }

    @Override
    void forEach(@Nonnull Proc2<K, V> proc) {
        this.left.forEach(proc);
        proc.apply(this.key, this.value);
        this.right.forEach(proc);
    }

    @Override
    <E extends Exception> void forEachThrows(@Nonnull Proc2Throws<K, V, E> proc) throws E {
        this.left.forEachThrows(proc);
        proc.apply(this.key, this.value);
        this.right.forEachThrows(proc);
    }

    @Override
    <R> R reduce(R sum, @Nonnull Sum2<K, V, R> proc) {
        sum = this.left.reduce(sum, proc);
        sum = proc.apply(sum, this.key, this.value);
        sum = this.right.reduce(sum, proc);
        return sum;
    }

    @Override
    <R, E extends Exception> R reduceThrows(R sum, @Nonnull Sum2Throws<K, V, R, E> proc) throws E {
        sum = this.left.reduceThrows(sum, proc);
        sum = proc.apply(sum, this.key, this.value);
        sum = this.right.reduceThrows(sum, proc);
        return sum;
    }
}

