/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.util;

import java.util.Iterator;
import java.util.Map;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Func2;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.JImmutableStack;
import org.javimmutable.collections.list.JImmutableLinkedStack;

public final class Functions {
    private Functions() {
    }

    public static <T, R> R foldLeft(R accumulator, Iterator<? extends T> iterator, Func2<R, ? super T, R> func) {
        while (iterator.hasNext()) {
            accumulator = func.apply(accumulator, iterator.next());
        }
        return accumulator;
    }

    public static <T, R> R foldRight(R accumulator, Iterator<? extends T> iterator, Func2<R, ? super T, R> func) {
        return Functions.foldLeft(accumulator, Functions.reverse(iterator), func);
    }

    public static <T> Iterator<T> reverse(Iterator<? extends T> iterator) {
        return ((JImmutableStack)JImmutableLinkedStack.of().insertAll(iterator)).iterator();
    }

    public static <T, R, A extends Insertable<R, A>> A collectAll(Iterator<? extends T> iterator, A list, Func1<? super T, R> func) {
        while (iterator.hasNext()) {
            list = list.insert(func.apply(iterator.next()));
        }
        return list;
    }

    public static <T, R, A extends Insertable<R, A>> A collectSome(Iterator<? extends T> iterator, A list, Func1<? super T, Holder<R>> func) {
        while (iterator.hasNext()) {
            Holder<R> mappedValue = func.apply(iterator.next());
            if (!mappedValue.isFilled()) continue;
            list = list.insert(mappedValue.getValue());
        }
        return list;
    }

    public static <T> Holder<T> find(Iterator<? extends T> iterator, Func1<? super T, Boolean> func) {
        while (iterator.hasNext()) {
            T value = iterator.next();
            if (!func.apply(value).booleanValue()) continue;
            return Holders.of(value);
        }
        return Holders.of();
    }

    public static <T, A extends Insertable<T, A>> A reject(Iterator<? extends T> iterator, A list, Func1<? super T, Boolean> func) {
        while (iterator.hasNext()) {
            T value = iterator.next();
            if (func.apply(value).booleanValue()) continue;
            list = list.insert(value);
        }
        return list;
    }

    public static <T, A extends Insertable<T, A>> A select(Iterator<? extends T> iterator, A list, Func1<? super T, Boolean> func) {
        while (iterator.hasNext()) {
            T value = iterator.next();
            if (!func.apply(value).booleanValue()) continue;
            list = list.insert(value);
        }
        return list;
    }

    public static <K, V> JImmutableMap<K, V> assignAll(JImmutableMap<K, V> dest, JImmutableMap<K, V> src) {
        for (JImmutableMap.Entry entry : src) {
            dest = dest.assign(entry.getKey(), entry.getValue());
        }
        return dest;
    }

    public static <K, V> JImmutableMap<K, V> assignAll(JImmutableMap<K, V> dest, Map<K, V> src) {
        for (Map.Entry<K, V> entry : src.entrySet()) {
            dest = dest.assign(entry.getKey(), entry.getValue());
        }
        return dest;
    }
}

