/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.InsertableSequence;
import org.javimmutable.collections.JImmutableArray;
import org.javimmutable.collections.JImmutableList;
import org.javimmutable.collections.JImmutableListMap;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.JImmutableMultiset;
import org.javimmutable.collections.JImmutableSet;
import org.javimmutable.collections.JImmutableSetMap;
import org.javimmutable.collections.JImmutableStack;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.array.JImmutableTrieArray;
import org.javimmutable.collections.hash.JImmutableHashMap;
import org.javimmutable.collections.hash.JImmutableHashMultiset;
import org.javimmutable.collections.hash.JImmutableHashSet;
import org.javimmutable.collections.indexed.IndexedArray;
import org.javimmutable.collections.indexed.IndexedList;
import org.javimmutable.collections.inorder.JImmutableInsertOrderMap;
import org.javimmutable.collections.inorder.JImmutableInsertOrderMultiset;
import org.javimmutable.collections.inorder.JImmutableInsertOrderSet;
import org.javimmutable.collections.list.JImmutableLinkedStack;
import org.javimmutable.collections.list.JImmutableTreeList;
import org.javimmutable.collections.listmap.JImmutableHashListMap;
import org.javimmutable.collections.listmap.JImmutableInsertOrderListMap;
import org.javimmutable.collections.listmap.JImmutableTreeListMap;
import org.javimmutable.collections.sequence.EmptySequenceNode;
import org.javimmutable.collections.sequence.FilledSequenceNode;
import org.javimmutable.collections.setmap.JImmutableHashSetMap;
import org.javimmutable.collections.setmap.JImmutableInsertOrderSetMap;
import org.javimmutable.collections.setmap.JImmutableSetMapFactory;
import org.javimmutable.collections.setmap.JImmutableTemplateSetMap;
import org.javimmutable.collections.setmap.JImmutableTreeSetMap;
import org.javimmutable.collections.tree.ComparableComparator;
import org.javimmutable.collections.tree.JImmutableTreeMap;
import org.javimmutable.collections.tree.JImmutableTreeMultiset;
import org.javimmutable.collections.tree.JImmutableTreeSet;
import org.javimmutable.collections.util.Functions;

public final class JImmutables {
    private JImmutables() {
    }

    @Nonnull
    public static <T> JImmutableStack<T> stack() {
        return JImmutableLinkedStack.of();
    }

    @Nonnull
    @SafeVarargs
    public static <T> JImmutableStack<T> stack(T ... source) {
        return (JImmutableStack)JImmutableLinkedStack.of().insertAll(Arrays.asList(source));
    }

    @Nonnull
    public static <T> JImmutableStack<T> stack(@Nonnull Iterable<? extends T> source) {
        return (JImmutableStack)JImmutableLinkedStack.of().insertAll(source);
    }

    @Nonnull
    public static <T> JImmutableStack<T> stack(@Nonnull Iterator<? extends T> source) {
        return (JImmutableStack)JImmutableLinkedStack.of().insertAll(source);
    }

    @Nonnull
    public static <T> JImmutableList<T> list() {
        return JImmutableTreeList.of();
    }

    @Nonnull
    public static <T> JImmutableList.Builder<T> listBuilder() {
        return JImmutableTreeList.listBuilder();
    }

    @Nonnull
    public static <T> Collector<T, ?, JImmutableList<T>> listCollector() {
        return JImmutableTreeList.createListCollector();
    }

    @Nonnull
    @SafeVarargs
    public static <T> JImmutableList<T> list(T ... values) {
        return JImmutableTreeList.of(IndexedArray.retained(values));
    }

    @Nonnull
    public static <T> JImmutableList<T> list(@Nonnull Indexed<? extends T> source) {
        return JImmutableTreeList.of(source);
    }

    @Nonnull
    public static <T> JImmutableList<T> list(@Nonnull Indexed<? extends T> source, int offset, int limit) {
        return JImmutableTreeList.of(source, offset, limit);
    }

    @Nonnull
    public static <T> JImmutableList<T> list(@Nonnull JImmutableSet<? extends T> source) {
        return JImmutableTreeList.of(source.iterator());
    }

    @Nonnull
    public static <T> JImmutableList<T> list(@Nonnull List<? extends T> source) {
        return JImmutableTreeList.of(IndexedList.retained(source));
    }

    @Nonnull
    public static <T> JImmutableList<T> list(@Nonnull Iterator<? extends T> source) {
        return JImmutableTreeList.of(source);
    }

    @Nonnull
    public static <T> JImmutableList<T> list(@Nonnull JImmutableList<? extends T> source) {
        return JImmutableTreeList.of(source);
    }

    @Nonnull
    public static <T> JImmutableList<T> list(@Nonnull Iterable<? extends T> source) {
        return JImmutableTreeList.of(source.iterator());
    }

    @Nonnull
    public static <K, V> JImmutableMap<K, V> map() {
        return JImmutableHashMap.of();
    }

    @Nonnull
    public static <K, V> JImmutableMap<K, V> map(@Nonnull Map<K, V> source) {
        return JImmutableHashMap.builder().add(source).build();
    }

    @Nonnull
    public static <K, V> JImmutableMap<K, V> map(@Nonnull JImmutableMap<K, V> source) {
        if (source instanceof JImmutableHashMap) {
            return source;
        }
        return JImmutableHashMap.builder().add(source).build();
    }

    @Nonnull
    public static <K, V> JImmutableMap.Builder<K, V> mapBuilder() {
        return JImmutableHashMap.builder();
    }

    @Nonnull
    public static <K, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableMap<K, V>> mapCollector() {
        return JImmutableHashMap.createMapCollector();
    }

    @Nonnull
    public static <K extends Comparable<K>, V> JImmutableMap<K, V> sortedMap() {
        return JImmutableTreeMap.of();
    }

    @Nonnull
    public static <K extends Comparable<K>, V> JImmutableMap<K, V> sortedMap(@Nonnull Map<K, V> source) {
        return JImmutables.sortedMap(ComparableComparator.of(), source);
    }

    @Nonnull
    public static <K extends Comparable<K>, V> JImmutableMap<K, V> sortedMap(@Nonnull JImmutableMap<K, V> source) {
        return JImmutables.sortedMap(ComparableComparator.of(), source);
    }

    @Nonnull
    public static <K, V> JImmutableMap<K, V> sortedMap(@Nonnull Comparator<K> comparator) {
        return JImmutableTreeMap.of(comparator);
    }

    @Nonnull
    public static <K, V> JImmutableMap<K, V> sortedMap(@Nonnull Comparator<K> comparator, @Nonnull Map<K, V> source) {
        return JImmutableTreeMap.builder(comparator).add(source).build();
    }

    @Nonnull
    public static <K, V> JImmutableMap<K, V> sortedMap(@Nonnull Comparator<K> comparator, @Nonnull JImmutableMap<K, V> source) {
        JImmutableTreeMap treemap;
        if (source instanceof JImmutableTreeMap && (treemap = (JImmutableTreeMap)source).getComparator().equals(comparator)) {
            return source;
        }
        return JImmutableTreeMap.builder(comparator).add(source).build();
    }

    @Nonnull
    public static <K extends Comparable<K>, V> JImmutableMap.Builder<K, V> sortedMapBuilder() {
        return JImmutableTreeMap.builder();
    }

    @Nonnull
    public static <K, V> JImmutableMap.Builder<K, V> sortedMapBuilder(@Nonnull Comparator<K> comparator) {
        return JImmutableTreeMap.builder(comparator);
    }

    @Nonnull
    public static <K extends Comparable<K>, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableMap<K, V>> sortedMapCollector() {
        return JImmutableTreeMap.createMapCollector();
    }

    @Nonnull
    public static <K extends Comparable<K>, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableMap<K, V>> sortedMapCollector(@Nonnull Comparator<K> comparator) {
        return JImmutableTreeMap.createMapCollector(comparator);
    }

    @Nonnull
    public static <K, V> JImmutableMap<K, V> insertOrderMap() {
        return JImmutableInsertOrderMap.of();
    }

    @Nonnull
    public static <K, V> JImmutableMap<K, V> insertOrderMap(@Nonnull Map<K, V> source) {
        return Functions.assignAll(JImmutableInsertOrderMap.of(), source);
    }

    @Nonnull
    public static <K, V> JImmutableMap<K, V> insertOrderMap(@Nonnull JImmutableMap<K, V> source) {
        if (source instanceof JImmutableInsertOrderMap) {
            return source;
        }
        return Functions.assignAll(JImmutableInsertOrderMap.of(), source);
    }

    @Nonnull
    public static <K, V> JImmutableMap.Builder<K, V> insertOrderMapBuilder() {
        return JImmutableInsertOrderMap.builder();
    }

    @Nonnull
    public static <K, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableMap<K, V>> insertOrderMapCollector() {
        return JImmutableInsertOrderMap.of().mapCollector();
    }

    @Nonnull
    public static <T> JImmutableSet<T> set() {
        return JImmutableHashSet.of();
    }

    @Nonnull
    @SafeVarargs
    public static <T> JImmutableSet<T> set(T ... source) {
        return JImmutableHashSet.builder().add(source).build();
    }

    @Nonnull
    public static <T> JImmutableSet<T> set(@Nonnull Iterable<? extends T> source) {
        return JImmutableHashSet.builder().add(source).build();
    }

    @Nonnull
    public static <T> JImmutableSet<T> set(@Nonnull Iterator<? extends T> source) {
        return JImmutableHashSet.builder().add(source).build();
    }

    @Nonnull
    public static <T> JImmutableSet.Builder<T> setBuilder() {
        return JImmutableHashSet.builder();
    }

    @Nonnull
    public static <T> Collector<T, ?, JImmutableSet<T>> setCollector() {
        return JImmutables.set().setCollector();
    }

    @Nonnull
    public static <T extends Comparable<T>> JImmutableSet<T> sortedSet() {
        return JImmutableTreeSet.of();
    }

    @Nonnull
    @SafeVarargs
    public static <T extends Comparable<T>> JImmutableSet<T> sortedSet(T ... source) {
        return JImmutableTreeSet.builder().add(source).build();
    }

    @Nonnull
    public static <T extends Comparable<T>> JImmutableSet<T> sortedSet(@Nonnull Iterable<? extends T> source) {
        return JImmutableTreeSet.builder().add(source).build();
    }

    @Nonnull
    public static <T extends Comparable<T>> JImmutableSet<T> sortedSet(@Nonnull Iterator<? extends T> source) {
        return JImmutableTreeSet.builder().add(source).build();
    }

    @Nonnull
    public static <T> JImmutableSet<T> sortedSet(@Nonnull Comparator<T> comparator) {
        return JImmutableTreeSet.of(comparator);
    }

    @Nonnull
    @SafeVarargs
    public static <T> JImmutableSet<T> sortedSet(@Nonnull Comparator<T> comparator, T ... source) {
        return JImmutableTreeSet.builder(comparator).add(source).build();
    }

    @Nonnull
    public static <T> JImmutableSet<T> sortedSet(@Nonnull Comparator<T> comparator, @Nonnull Iterable<? extends T> source) {
        return JImmutableTreeSet.builder(comparator).add(source).build();
    }

    @Nonnull
    public static <T> JImmutableSet<T> sortedSet(@Nonnull Comparator<T> comparator, @Nonnull Iterator<? extends T> source) {
        return JImmutableTreeSet.builder(comparator).add(source).build();
    }

    @Nonnull
    public static <T extends Comparable<T>> JImmutableSet.Builder<T> sortedSetBuilder() {
        return JImmutableTreeSet.builder();
    }

    @Nonnull
    public static <T> JImmutableSet.Builder<T> sortedSetBuilder(@Nonnull Comparator<T> comparator) {
        return JImmutableTreeSet.builder(comparator);
    }

    @Nonnull
    public static <T extends Comparable<T>> Collector<T, ?, JImmutableSet<T>> sortedSetCollector() {
        return JImmutables.sortedSet().setCollector();
    }

    @Nonnull
    public static <T> Collector<T, ?, JImmutableSet<T>> sortedSetCollector(@Nonnull Comparator<T> comparator) {
        return JImmutables.sortedSet(comparator).setCollector();
    }

    @Nonnull
    public static <T> JImmutableSet<T> insertOrderSet() {
        return JImmutableInsertOrderSet.of();
    }

    @Nonnull
    @SafeVarargs
    public static <T> JImmutableSet<T> insertOrderSet(T ... source) {
        return JImmutableInsertOrderSet.builder().add(source).build();
    }

    @Nonnull
    public static <T> JImmutableSet<T> insertOrderSet(@Nonnull Iterable<? extends T> source) {
        return JImmutableInsertOrderSet.builder().add(source).build();
    }

    @Nonnull
    public static <T> JImmutableSet<T> insertOrderSet(@Nonnull Iterator<? extends T> source) {
        return JImmutableInsertOrderSet.builder().add(source).build();
    }

    @Nonnull
    public static <T> JImmutableSet.Builder<T> insertOrderSetBuilder() {
        return JImmutableInsertOrderSet.builder();
    }

    @Nonnull
    public static <T> Collector<T, ?, JImmutableSet<T>> insertOrderSetCollector() {
        return JImmutables.insertOrderSet().setCollector();
    }

    @Nonnull
    public static <T> JImmutableMultiset<T> multiset() {
        return JImmutableHashMultiset.of();
    }

    @Nonnull
    @SafeVarargs
    public static <T> JImmutableMultiset<T> multiset(T ... source) {
        return JImmutableHashMultiset.of().insertAll(Arrays.asList(source));
    }

    @Nonnull
    public static <T> JImmutableMultiset<T> multiset(@Nonnull Iterable<? extends T> source) {
        return JImmutableHashMultiset.of().insertAll((Iterable)source);
    }

    @Nonnull
    public static <T> JImmutableMultiset<T> multiset(@Nonnull Iterator<? extends T> source) {
        return JImmutableHashMultiset.of().insertAll((Iterator)source);
    }

    @Nonnull
    public static <T> Collector<T, ?, JImmutableMultiset<T>> multisetCollector() {
        return JImmutables.multiset().multisetCollector();
    }

    @Nonnull
    public static <T extends Comparable<T>> JImmutableMultiset<T> sortedMultiset() {
        return JImmutableTreeMultiset.of();
    }

    @Nonnull
    @SafeVarargs
    public static <T extends Comparable<T>> JImmutableMultiset<T> sortedMultiset(T ... source) {
        return JImmutableTreeMultiset.of().insertAll(Arrays.asList(source));
    }

    @Nonnull
    public static <T extends Comparable<T>> JImmutableMultiset<T> sortedMultiset(@Nonnull Iterable<? extends T> source) {
        return JImmutableTreeMultiset.of().insertAll((Iterable)source);
    }

    @Nonnull
    public static <T extends Comparable<T>> JImmutableMultiset<T> sortedMultiset(@Nonnull Iterator<? extends T> source) {
        return JImmutableTreeMultiset.of().insertAll((Iterator)source);
    }

    @Nonnull
    public static <T> JImmutableMultiset<T> sortedMultiset(@Nonnull Comparator<T> comparator) {
        return JImmutableTreeMultiset.of(comparator);
    }

    @Nonnull
    @SafeVarargs
    public static <T> JImmutableMultiset<T> sortedMultiset(@Nonnull Comparator<T> comparator, T ... source) {
        return JImmutableTreeMultiset.of(comparator).insertAll(Arrays.asList(source));
    }

    @Nonnull
    public static <T> JImmutableMultiset<T> sortedMultiset(@Nonnull Comparator<T> comparator, @Nonnull Iterable<? extends T> source) {
        return JImmutableTreeMultiset.of(comparator).insertAll((Iterable)source);
    }

    @Nonnull
    public static <T> JImmutableMultiset<T> sortedMultiset(@Nonnull Comparator<T> comparator, @Nonnull Iterator<? extends T> source) {
        return JImmutableTreeMultiset.of(comparator).insertAll(source);
    }

    @Nonnull
    public static <T extends Comparable<T>> Collector<T, ?, JImmutableMultiset<T>> sortedMultisetCollector() {
        return JImmutables.sortedMultiset().multisetCollector();
    }

    @Nonnull
    public static <T> Collector<T, ?, JImmutableMultiset<T>> sortedMultisetCollector(@Nonnull Comparator<T> comparator) {
        return JImmutables.sortedMultiset(comparator).multisetCollector();
    }

    @Nonnull
    public static <T> JImmutableMultiset<T> insertOrderMultiset() {
        return JImmutableInsertOrderMultiset.of();
    }

    @Nonnull
    @SafeVarargs
    public static <T> JImmutableMultiset<T> insertOrderMultiset(T ... source) {
        return JImmutableInsertOrderMultiset.of().insertAll(Arrays.asList(source));
    }

    @Nonnull
    public static <T> JImmutableMultiset<T> insertOrderMultiset(@Nonnull Iterable<? extends T> source) {
        return JImmutableInsertOrderMultiset.of().insertAll((Iterable)source);
    }

    @Nonnull
    public static <T> JImmutableMultiset<T> insertOrderMultiset(@Nonnull Iterator<? extends T> source) {
        return JImmutableInsertOrderMultiset.of().insertAll((Iterator)source);
    }

    @Nonnull
    public static <T> Collector<T, ?, JImmutableMultiset<T>> insertOrderMultisetCollector() {
        return JImmutables.insertOrderMultiset().multisetCollector();
    }

    @Nonnull
    public static <K, V> JImmutableListMap<K, V> listMap() {
        return JImmutableHashListMap.of();
    }

    @Nonnull
    public static <K, V> JImmutableListMap<K, V> insertOrderListMap() {
        return JImmutableInsertOrderListMap.of();
    }

    @Nonnull
    public static <K extends Comparable<K>, V> JImmutableListMap<K, V> sortedListMap() {
        return JImmutableTreeListMap.of();
    }

    @Nonnull
    public static <K, V> JImmutableListMap<K, V> sortedListMap(@Nonnull Comparator<K> comparator) {
        return JImmutableTreeListMap.of(comparator);
    }

    @Nonnull
    public static <K, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableListMap<K, V>> listMapCollector() {
        return JImmutables.listMap().listMapCollector();
    }

    @Nonnull
    public static <K, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableListMap<K, V>> insertOrderListMapCollector() {
        return JImmutables.insertOrderListMap().listMapCollector();
    }

    @Nonnull
    public static <K extends Comparable<K>, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableListMap<K, V>> sortedListMapCollector() {
        return JImmutables.sortedListMap().listMapCollector();
    }

    @Nonnull
    public static <K extends Comparable<K>, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableListMap<K, V>> sortedListMapCollector(@Nonnull Comparator<K> comparator) {
        return JImmutables.sortedListMap(comparator).listMapCollector();
    }

    @Nonnull
    public static <K, V> JImmutableSetMap<K, V> setMap() {
        return JImmutableHashSetMap.of();
    }

    @Nonnull
    public static <K, V> JImmutableSetMapFactory<K, V> setMapFactory() {
        return new JImmutableSetMapFactory();
    }

    @Nonnull
    public static <K, V> JImmutableSetMapFactory<K, V> setMapFactory(@Nonnull Class<K> keyClass, @Nonnull Class<V> valueClass) {
        return new JImmutableSetMapFactory();
    }

    @Nonnull
    public static <K, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableSetMap<K, V>> setMapCollector() {
        return JImmutables.setMap().setMapCollector();
    }

    @Nonnull
    public static <K, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableSetMap<K, V>> insertOrderSetMapCollector() {
        return JImmutables.insertOrderSetMap().setMapCollector();
    }

    @Nonnull
    public static <K extends Comparable<K>, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableSetMap<K, V>> sortedSetMapCollector() {
        return JImmutables.sortedSetMap().setMapCollector();
    }

    @Nonnull
    public static <K extends Comparable<K>, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableSetMap<K, V>> sortedSetMapCollector(@Nonnull Comparator<K> comparator) {
        return JImmutables.sortedSetMap(comparator).setMapCollector();
    }

    @Nonnull
    public static <K, V> JImmutableSetMap<K, V> insertOrderSetMap() {
        return JImmutableInsertOrderSetMap.of();
    }

    @Nonnull
    public static <K extends Comparable<K>, V> JImmutableSetMap<K, V> sortedSetMap() {
        return JImmutableTreeSetMap.of();
    }

    @Nonnull
    public static <K, V> JImmutableSetMap<K, V> sortedSetMap(@Nonnull Comparator<K> comparator) {
        return JImmutableTreeSetMap.of(comparator);
    }

    @Nonnull
    public static <K, V> JImmutableSetMap<K, V> setMap(@Nonnull JImmutableMap<K, JImmutableSet<V>> templateMap, @Nonnull JImmutableSet<V> templateSet) {
        return JImmutableTemplateSetMap.of(templateMap, templateSet);
    }

    @Nonnull
    public static <T> JImmutableArray<T> array() {
        return JImmutableTrieArray.of();
    }

    @Nonnull
    @SafeVarargs
    public static <T> JImmutableArray<T> array(T ... source) {
        return JImmutableTrieArray.builder().add(source).build();
    }

    @Nonnull
    public static <T> JImmutableArray<T> array(@Nonnull Iterator<JImmutableMap.Entry<Integer, T>> source) {
        return (JImmutableArray)JImmutableTrieArray.of().insertAll(source);
    }

    @Nonnull
    public static <T> JImmutableArray<T> array(@Nonnull Indexed<? extends T> source) {
        return JImmutableTrieArray.builder().add(source).build();
    }

    @Nonnull
    public static <T> JImmutableArray<T> array(@Nonnull Indexed<? extends T> source, int offset, int limit) {
        return JImmutableTrieArray.builder().add(source, offset, limit).build();
    }

    @Nonnull
    public static <T> JImmutableArray<T> array(@Nonnull Iterable<? extends T> source) {
        return JImmutableTrieArray.builder().add(source).build();
    }

    @Nonnull
    public static <T> JImmutableArray.Builder<T> arrayBuilder() {
        return JImmutableTrieArray.builder();
    }

    @Nonnull
    public static <T> Collector<T, ?, JImmutableArray<T>> arrayCollector() {
        return JImmutableTrieArray.collector();
    }

    @Nonnull
    public static <T> InsertableSequence<T> sequence() {
        return EmptySequenceNode.of();
    }

    @Nonnull
    public static <T> InsertableSequence<T> sequence(T value) {
        return FilledSequenceNode.of(value);
    }

    @Nonnull
    public static <K, V, K1 extends K, V1 extends V> JImmutableMap.Entry<K, V> entry(K1 key, V1 value) {
        return MapEntry.of(key, value);
    }

    @Nonnull
    public static <K, V> JImmutableMap.Entry<K, V> entry(@Nonnull JImmutableMap.Entry<? extends K, ? extends V> e) {
        return MapEntry.of(e.getKey(), e.getValue());
    }

    @Nonnull
    public static <K, V> JImmutableMap.Entry<K, V> entry(@Nonnull Map.Entry<? extends K, ? extends V> e) {
        return MapEntry.of(e.getKey(), e.getValue());
    }
}

