/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.util;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Random;
import java.util.TreeMap;
import org.javimmutable.collections.JImmutableArray;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.array.JImmutableTrieArray;
import org.javimmutable.collections.common.MutableDelta;
import org.javimmutable.collections.hash.JImmutableHashMap;
import org.javimmutable.collections.inorder.JImmutableInsertOrderMap;
import org.javimmutable.collections.tree.JImmutableTreeMap;

public final class MapTimingComparison {
    private MapTimingComparison() {
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 2) {
            System.err.println("usage: TimingComparison seed loops");
            System.exit(1);
        }
        int seed = Integer.parseInt(argv[0]);
        int loops = Integer.parseInt(argv[1]);
        MutableDelta javaHashElapsed = new MutableDelta();
        MutableDelta javaTreeElapsed = new MutableDelta();
        MutableDelta hashElapsed = new MutableDelta();
        MutableDelta treeElapsed = new MutableDelta();
        MutableDelta arrayElapsed = new MutableDelta();
        MutableDelta inOrderElapsed = new MutableDelta();
        System.out.println("warm up runs");
        int maxValue = 10 * loops;
        int maxKey = 100000000;
        int maxCommand = 10;
        MapTimingComparison.runLoop(seed, loops, maxValue, 100000000, 10, new MutableDelta(), new MutableDelta(), new MutableDelta(), new MutableDelta(), new MutableDelta(), new MutableDelta());
        MapTimingComparison.runLoop(seed, loops, maxValue, 100000000, 10, new MutableDelta(), new MutableDelta(), new MutableDelta(), new MutableDelta(), new MutableDelta(), new MutableDelta());
        MapTimingComparison.runLoop(seed, loops, maxValue, 100000000, 10, new MutableDelta(), new MutableDelta(), new MutableDelta(), new MutableDelta(), new MutableDelta(), new MutableDelta());
        MapTimingComparison.runLoop(seed, loops, maxValue, 100000000, 10, new MutableDelta(), new MutableDelta(), new MutableDelta(), new MutableDelta(), new MutableDelta(), new MutableDelta());
        System.out.println();
        System.out.println("real runs");
        for (int i = 0; i < 25; ++i) {
            MapTimingComparison.runLoop(seed + i, loops, maxValue, 100000000, 10, javaHashElapsed, javaTreeElapsed, hashElapsed, treeElapsed, arrayElapsed, inOrderElapsed);
            System.out.println();
        }
        System.out.printf("jhash avg: %.1f  jtree avg: %.1f  tree avg: %.1f  hash avg: %.1f  array avg: %.1f  order avg: %.1f%n", (double)javaHashElapsed.getValue() / 25.0, (double)javaTreeElapsed.getValue() / 25.0, (double)treeElapsed.getValue() / 25.0, (double)hashElapsed.getValue() / 25.0, (double)arrayElapsed.getValue() / 25.0, (double)inOrderElapsed.getValue() / 25.0);
    }

    private static void runLoop(int seed, int loops, int maxValue, int maxKey, int maxCommand, MutableDelta javaHashElapsed, MutableDelta javaTreeElapsed, MutableDelta hashElapsed, MutableDelta treeElapsed, MutableDelta arrayElapsed, MutableDelta inOrderElapsed) throws Exception {
        Integer value;
        Integer key;
        int i;
        Random random = new Random(seed);
        int adds = 0;
        int removes = 0;
        int gets = 0;
        long startMillis = System.currentTimeMillis();
        AbstractMap expected = new HashMap<Integer, Integer>();
        for (int i2 = 1; i2 <= loops; ++i2) {
            Integer key2;
            int command = random.nextInt(maxCommand);
            if (command <= 2) {
                key2 = random.nextInt(maxKey);
                Integer value2 = random.nextInt(maxValue);
                expected.put(key2, value2);
                ++adds;
                continue;
            }
            if (command == 3) {
                key2 = random.nextInt(maxKey);
                expected.remove(key2);
                ++removes;
                continue;
            }
            key2 = random.nextInt(maxKey);
            expected.get(key2);
            ++gets;
        }
        long endMillis = System.currentTimeMillis();
        javaHashElapsed.add((int)(endMillis - startMillis));
        System.out.printf("java map adds %d removes %d gets %d size %d elapsed %d%n", adds, removes, gets, expected.size(), endMillis - startMillis);
        expected = null;
        System.gc();
        Thread.sleep(500L);
        random = new Random(seed);
        adds = 0;
        removes = 0;
        gets = 0;
        startMillis = System.currentTimeMillis();
        expected = new TreeMap();
        for (int i3 = 1; i3 <= loops; ++i3) {
            Integer key3;
            int command = random.nextInt(maxCommand);
            if (command <= 2) {
                key3 = random.nextInt(maxKey);
                Integer value3 = random.nextInt(maxValue);
                expected.put(key3, value3);
                ++adds;
                continue;
            }
            if (command == 3) {
                key3 = random.nextInt(maxKey);
                expected.remove(key3);
                ++removes;
                continue;
            }
            key3 = random.nextInt(maxKey);
            expected.get(key3);
            ++gets;
        }
        endMillis = System.currentTimeMillis();
        javaTreeElapsed.add((int)(endMillis - startMillis));
        System.out.printf("java tree adds %d removes %d gets %d size %d elapsed %d%n", adds, removes, gets, expected.size(), endMillis - startMillis);
        expected = null;
        System.gc();
        Thread.sleep(500L);
        random = new Random(seed);
        adds = 0;
        removes = 0;
        gets = 0;
        startMillis = System.currentTimeMillis();
        JImmutableMap<Object, Object> map = JImmutableTreeMap.of();
        for (i = 1; i <= loops; ++i) {
            int command = random.nextInt(maxCommand);
            if (command <= 2) {
                key = random.nextInt(maxKey);
                value = random.nextInt(maxValue);
                map = map.assign(key, value);
                ++adds;
                continue;
            }
            if (command == 3) {
                key = random.nextInt(maxKey);
                map = map.delete(key);
                ++removes;
                continue;
            }
            key = random.nextInt(maxKey);
            map.getValueOr(key, null);
            ++gets;
        }
        endMillis = System.currentTimeMillis();
        treeElapsed.add((int)(endMillis - startMillis));
        System.out.printf("jimm tree adds %d removes %d gets %d size %d elapsed %d%n", adds, removes, gets, map.size(), endMillis - startMillis);
        map = null;
        System.gc();
        Thread.sleep(500L);
        random = new Random(seed);
        adds = 0;
        removes = 0;
        gets = 0;
        startMillis = System.currentTimeMillis();
        map = JImmutableHashMap.of();
        for (i = 1; i <= loops; ++i) {
            int command = random.nextInt(maxCommand);
            if (command <= 2) {
                key = random.nextInt(maxKey);
                value = random.nextInt(maxValue);
                map = map.assign(key, value);
                ++adds;
                continue;
            }
            if (command == 3) {
                key = random.nextInt(maxKey);
                map = map.delete(key);
                ++removes;
                continue;
            }
            key = random.nextInt(maxKey);
            map.getValueOr(key, null);
            ++gets;
        }
        endMillis = System.currentTimeMillis();
        hashElapsed.add((int)(endMillis - startMillis));
        System.out.printf("jimm hash adds %d removes %d gets %d size %d elapsed %d%n", adds, removes, gets, map.size(), endMillis - startMillis);
        map = null;
        System.gc();
        Thread.sleep(500L);
        random = new Random(seed);
        adds = 0;
        removes = 0;
        gets = 0;
        startMillis = System.currentTimeMillis();
        map = JImmutableInsertOrderMap.of();
        for (i = 1; i <= loops; ++i) {
            int command = random.nextInt(maxCommand);
            if (command <= 2) {
                key = random.nextInt(maxKey);
                value = random.nextInt(maxValue);
                map = map.assign(key, value);
                ++adds;
                continue;
            }
            if (command == 3) {
                key = random.nextInt(maxKey);
                map = map.delete(key);
                ++removes;
                continue;
            }
            key = random.nextInt(maxKey);
            map.getValueOr(key, null);
            ++gets;
        }
        endMillis = System.currentTimeMillis();
        inOrderElapsed.add((int)(endMillis - startMillis));
        System.out.printf("jimm iord adds %d removes %d gets %d size %d elapsed %d%n", adds, removes, gets, map.size(), endMillis - startMillis);
        map = null;
        System.gc();
        Thread.sleep(500L);
        random = new Random(seed);
        adds = 0;
        removes = 0;
        gets = 0;
        startMillis = System.currentTimeMillis();
        JImmutableArray<Object> array = JImmutableTrieArray.of();
        for (int i4 = 1; i4 <= loops; ++i4) {
            Integer key4;
            int command = random.nextInt(maxCommand);
            if (command <= 2) {
                key4 = random.nextInt(maxKey);
                Integer value4 = random.nextInt(maxValue);
                array = array.assign(key4, value4);
                ++adds;
                continue;
            }
            if (command == 3) {
                key4 = random.nextInt(maxKey);
                array = array.delete(key4);
                ++removes;
                continue;
            }
            key4 = random.nextInt(maxKey);
            array.find(key4);
            ++gets;
        }
        endMillis = System.currentTimeMillis();
        arrayElapsed.add((int)(endMillis - startMillis));
        System.out.printf("jimm arry adds %d removes %d gets %d size %d elapsed %d%n", adds, removes, gets, array.size(), endMillis - startMillis);
        array = null;
        System.gc();
        Thread.sleep(500L);
    }
}

