/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.javimmutable.collections.Func0;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Func2;
import org.javimmutable.collections.Func3;
import org.javimmutable.collections.Func4;

public final class ReflectionFunctions {
    private ReflectionFunctions() {
    }

    public static <R> Func0<R> method(Object obj, String name) {
        return new ReflectionFunc0(ReflectionFunctions.findMethod(obj.getClass(), name, false, new Class[0]), obj);
    }

    public static <P1, R> Func1<P1, R> method(Object obj, String name, Class<P1> arg1Class) {
        return new ReflectionFunc1(ReflectionFunctions.findMethod(obj.getClass(), name, false, arg1Class), obj);
    }

    public static <P1, P2, R> Func2<P1, P2, R> method(Object obj, String name, Class<P1> arg1Class, Class<P2> arg2Class) {
        return new ReflectionFunc2(ReflectionFunctions.findMethod(obj.getClass(), name, false, arg1Class, arg2Class), obj);
    }

    public static <P1, P2, P3, R> Func3<P1, P2, P3, R> method(Object obj, String name, Class<P1> arg1Class, Class<P2> arg2Class, Class<P3> arg3Class) {
        return new ReflectionFunc3(ReflectionFunctions.findMethod(obj.getClass(), name, false, arg1Class, arg2Class, arg3Class), obj);
    }

    public static <P1, P2, P3, P4, R> Func4<P1, P2, P3, P4, R> method(Object obj, String name, Class<P1> arg1Class, Class<P2> arg2Class, Class<P3> arg3Class, Class<P4> arg4Class) {
        return new ReflectionFunc4(ReflectionFunctions.findMethod(obj.getClass(), name, false, arg1Class, arg2Class, arg3Class, arg4Class), obj);
    }

    public static <OT, R> Func1<OT, R> method(String name, Class<OT> klass) {
        return new ParamReflectionFunc1(ReflectionFunctions.findMethod(klass, name, false, new Class[0]));
    }

    public static <P1, OT, R> Func2<P1, OT, R> method(String name, Class<P1> arg1Class, Class<OT> klass) {
        return new ParamReflectionFunc2(ReflectionFunctions.findMethod(klass, name, false, arg1Class));
    }

    public static <P1, P2, OT, R> Func3<P1, P2, OT, R> method(String name, Class<P1> arg1Class, Class<P2> arg2Class, Class<OT> klass) {
        return new ParamReflectionFunc3(ReflectionFunctions.findMethod(klass, name, false, arg1Class, arg2Class));
    }

    public static <P1, P2, P3, OT, R> Func4<P1, P2, P3, OT, R> method(String name, Class<P1> arg1Class, Class<P2> arg2Class, Class<P3> arg3Class, Class<OT> klass) {
        return new ParamReflectionFunc4(ReflectionFunctions.findMethod(klass, name, false, arg1Class, arg2Class, arg3Class));
    }

    public static <R> Func0<R> staticMethod(Class klass, String name) {
        return new ReflectionFunc0(ReflectionFunctions.findMethod(klass, name, true, new Class[0]), null);
    }

    public static <P1, R> Func1<P1, R> staticMethod(Class klass, String name, Class<P1> arg1Class) {
        return new ReflectionFunc1(ReflectionFunctions.findMethod(klass, name, true, arg1Class), null);
    }

    public static <P1, P2, R> Func2<P1, P2, R> staticMethod(Class klass, String name, Class<P1> arg1Class, Class<P2> arg2Class) {
        return new ReflectionFunc2(ReflectionFunctions.findMethod(klass, name, true, arg1Class, arg2Class), null);
    }

    public static <P1, P2, P3, R> Func3<P1, P2, P3, R> staticMethod(Class klass, String name, Class<P1> arg1Class, Class<P2> arg2Class, Class<P3> arg3Class) {
        return new ReflectionFunc3(ReflectionFunctions.findMethod(klass, name, true, arg1Class, arg2Class, arg3Class), null);
    }

    public static <P1, P2, P3, P4, R> Func4<P1, P2, P3, P4, R> staticMethod(Class klass, String name, Class<P1> arg1Class, Class<P2> arg2Class, Class<P3> arg3Class, Class<P4> arg4Class) {
        return new ReflectionFunc4(ReflectionFunctions.findMethod(klass, name, true, arg1Class, arg2Class, arg3Class, arg4Class), null);
    }

    private static Object callMethod(Method method, Object obj, Object ... params) {
        try {
            return method.invoke(obj, params);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    private static Method findMethod(Class klass, String name, boolean expectStatic, Class ... args) {
        try {
            boolean isStatic;
            Method method = klass.getMethod(name, args);
            boolean bl = isStatic = (method.getModifiers() & 8) != 0;
            if (isStatic != expectStatic) {
                throw new StaticMismatchException();
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    private static class ParamReflectionFunc4<P1, P2, P3, OT, R>
    extends NoInstanceReflectionBase
    implements Func4<P1, P2, P3, OT, R> {
        private ParamReflectionFunc4(Method method) {
            super(method);
        }

        @Override
        public R apply(P1 param1, P2 param2, P3 param3, OT obj) {
            return (R)ReflectionFunctions.callMethod(this.method, obj, new Object[]{param1, param2, param3});
        }
    }

    private static class ParamReflectionFunc3<P1, P2, OT, R>
    extends NoInstanceReflectionBase
    implements Func3<P1, P2, OT, R> {
        private ParamReflectionFunc3(Method method) {
            super(method);
        }

        @Override
        public R apply(P1 param1, P2 param2, OT obj) {
            return (R)ReflectionFunctions.callMethod(this.method, obj, new Object[]{param1, param2});
        }
    }

    private static class ParamReflectionFunc2<P1, OT, R>
    extends NoInstanceReflectionBase
    implements Func2<P1, OT, R> {
        private ParamReflectionFunc2(Method method) {
            super(method);
        }

        @Override
        public R apply(P1 param1, OT obj) {
            return (R)ReflectionFunctions.callMethod(this.method, obj, new Object[]{param1});
        }
    }

    private static class ParamReflectionFunc1<OT, R>
    extends NoInstanceReflectionBase
    implements Func1<OT, R> {
        private ParamReflectionFunc1(Method method) {
            super(method);
        }

        @Override
        public R apply(OT obj) {
            return (R)ReflectionFunctions.callMethod(this.method, obj, new Object[0]);
        }
    }

    private static class ReflectionFunc4<P1, P2, P3, P4, R>
    extends ReflectionBase
    implements Func4<P1, P2, P3, P4, R> {
        private ReflectionFunc4(Method method, Object obj) {
            super(method, obj);
        }

        @Override
        public R apply(P1 param1, P2 param2, P3 param3, P4 param4) {
            return (R)ReflectionFunctions.callMethod(this.method, this.obj, new Object[]{param1, param2, param3, param4});
        }
    }

    private static class ReflectionFunc3<P1, P2, P3, R>
    extends ReflectionBase
    implements Func3<P1, P2, P3, R> {
        private ReflectionFunc3(Method method, Object obj) {
            super(method, obj);
        }

        @Override
        public R apply(P1 param1, P2 param2, P3 param3) {
            return (R)ReflectionFunctions.callMethod(this.method, this.obj, new Object[]{param1, param2, param3});
        }
    }

    private static class ReflectionFunc2<P1, P2, R>
    extends ReflectionBase
    implements Func2<P1, P2, R> {
        private ReflectionFunc2(Method method, Object obj) {
            super(method, obj);
        }

        @Override
        public R apply(P1 param1, P2 param2) {
            return (R)ReflectionFunctions.callMethod(this.method, this.obj, new Object[]{param1, param2});
        }
    }

    private static class ReflectionFunc1<P1, R>
    extends ReflectionBase
    implements Func1<P1, R> {
        private ReflectionFunc1(Method method, Object obj) {
            super(method, obj);
        }

        @Override
        public R apply(P1 param1) {
            return (R)ReflectionFunctions.callMethod(this.method, this.obj, new Object[]{param1});
        }
    }

    private static class ReflectionFunc0<R>
    extends ReflectionBase
    implements Func0<R> {
        private ReflectionFunc0(Method method, Object obj) {
            super(method, obj);
        }

        @Override
        public R apply() {
            return (R)ReflectionFunctions.callMethod(this.method, this.obj, new Object[0]);
        }
    }

    private static class ReflectionBase
    extends NoInstanceReflectionBase {
        protected final Object obj;

        private ReflectionBase(Method method, Object obj) {
            super(method);
            this.obj = obj;
        }
    }

    private static class NoInstanceReflectionBase {
        protected final Method method;

        private NoInstanceReflectionBase(Method method) {
            this.method = method;
        }
    }

    public static class StaticMismatchException
    extends RuntimeException {
        public StaticMismatchException() {
            super("static modifier on method does not match expected value");
        }
    }

    public static class ReflectionException
    extends RuntimeException {
        public ReflectionException(Throwable throwable) {
            super(throwable);
        }
    }
}

