/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.util;

import java.util.Iterator;
import javax.annotation.Nonnull;
import org.javimmutable.collections.Proc2;
import org.javimmutable.collections.Proc2Throws;
import org.javimmutable.collections.Sum2;
import org.javimmutable.collections.Sum2Throws;

public class Zip {
    public static <A, B> void forEach(@Nonnull Iterable<A> a, @Nonnull Iterable<B> b, @Nonnull Proc2<A, B> operation) {
        Iterator<A> ai = a.iterator();
        Iterator<B> bi = b.iterator();
        while (ai.hasNext() && bi.hasNext()) {
            operation.apply(ai.next(), bi.next());
        }
    }

    public static <A, B, E extends Exception> void forEachThrows(@Nonnull Iterable<A> a, @Nonnull Iterable<B> b, @Nonnull Proc2Throws<A, B, E> operation) throws E {
        Iterator<A> ai = a.iterator();
        Iterator<B> bi = b.iterator();
        while (ai.hasNext() && bi.hasNext()) {
            operation.apply(ai.next(), bi.next());
        }
    }

    public static <A, B, R> R reduce(R sum, @Nonnull Iterable<A> a, @Nonnull Iterable<B> b, @Nonnull Sum2<A, B, R> operation) {
        Iterator<A> ai = a.iterator();
        Iterator<B> bi = b.iterator();
        while (ai.hasNext() && bi.hasNext()) {
            sum = operation.apply(sum, ai.next(), bi.next());
        }
        return sum;
    }

    public static <A, B, R, E extends Exception> R reduceThrows(R sum, @Nonnull Iterable<A> a, @Nonnull Iterable<B> b, @Nonnull Sum2Throws<A, B, R, E> operation) throws E {
        Iterator<A> ai = a.iterator();
        Iterator<B> bi = b.iterator();
        while (ai.hasNext() && bi.hasNext()) {
            sum = operation.apply(sum, ai.next(), bi.next());
        }
        return sum;
    }
}

