/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.maven;

import com.orientechnologies.orient.core.Orient;
import java.io.File;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jbake.app.ConfigUtil;
import org.jbake.app.Oven;

@Mojo(name="generate", requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(property="jbake.outputDirectory", defaultValue="${project.build.directory}/${project.build.finalName}", required=true)
    protected File outputDirectory;
    @Parameter(property="jbake.inputDirectory", defaultValue="${project.basedir}/src/main/jbake", required=true)
    protected File inputDirectory;
    @Parameter(property="jbake.isClearCache", defaultValue="false", required=true)
    protected boolean isClearCache;

    public final void execute() throws MojoExecutionException {
        try {
            this.executeInternal();
        }
        finally {
            this.closeQuietly();
        }
    }

    protected final void closeQuietly() {
        try {
            Orient.instance().shutdown();
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Oops", (Throwable)e);
        }
    }

    protected void executeInternal() throws MojoExecutionException {
        this.reRender();
    }

    protected void reRender() throws MojoExecutionException {
        try {
            Orient.instance().startup();
            Oven oven = new Oven(this.inputDirectory, this.outputDirectory, this.createConfiguration(), this.isClearCache);
            oven.setupPaths();
            oven.bake();
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)"Oops", (Throwable)e);
            throw new MojoExecutionException("Failure when running: ", e);
        }
    }

    protected CompositeConfiguration createConfiguration() throws ConfigurationException {
        CompositeConfiguration config = new CompositeConfiguration();
        config.addConfiguration((Configuration)ConfigUtil.load((File)this.inputDirectory));
        config.addConfiguration((Configuration)new MapConfiguration(this.project.getProperties()));
        return config;
    }
}

