/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.maven;

import java.io.File;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jbake.app.Oven;
import org.jbake.app.configuration.DefaultJBakeConfiguration;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.app.configuration.JBakeConfigurationFactory;

@Mojo(name="generate", requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(property="jbake.outputDirectory", defaultValue="${project.build.directory}/${project.build.finalName}", required=true)
    protected File outputDirectory;
    @Parameter(property="jbake.inputDirectory", defaultValue="${project.basedir}/src/main/jbake", required=true)
    protected File inputDirectory;
    @Parameter(property="jbake.failOnError", defaultValue="true")
    protected boolean failOnError;
    @Parameter(property="jbake.isClearCache", defaultValue="false", required=true)
    protected boolean isClearCache;

    public final void execute() throws MojoExecutionException {
        this.executeInternal();
    }

    protected void executeInternal() throws MojoExecutionException {
        this.reRender();
    }

    protected void reRender() throws MojoExecutionException {
        try {
            Oven oven = new Oven(this.createConfiguration());
            oven.bake();
            if (this.failOnError && !oven.getErrors().isEmpty()) {
                throw new MojoFailureException("Baked with " + oven.getErrors().size() + " errors. Check output above for details!");
            }
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)"Oops", (Throwable)e);
            throw new MojoExecutionException("Failure when running: ", e);
        }
    }

    protected JBakeConfiguration createConfiguration() throws ConfigurationException {
        DefaultJBakeConfiguration jBakeConfiguration = new JBakeConfigurationFactory().createDefaultJbakeConfiguration(this.inputDirectory, this.outputDirectory, this.isClearCache);
        jBakeConfiguration.getCompositeConfiguration().addConfiguration((Configuration)new MapConfiguration(this.project.getProperties()));
        return jBakeConfiguration;
    }
}

