/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.maven.util;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class DirWatcher {
    private final FileAlterationObserver observer;
    private final FileAlterationMonitor monitor;
    private final BlockingQueue<Long> changeQueue = new ArrayBlockingQueue<Long>(1);

    public DirWatcher(File dir) throws IOException {
        this.observer = new FileAlterationObserver(dir);
        this.monitor = new FileAlterationMonitor(1000L, new FileAlterationObserver[]{this.observer});
        this.observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

            public void onFileCreate(File file) {
                DirWatcher.this.onUpdated();
            }

            public void onFileChange(File file) {
                DirWatcher.this.onUpdated();
            }
        });
    }

    public void start() throws Exception {
        this.monitor.start();
    }

    public void stop() {
        try {
            this.monitor.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onUpdated() {
        this.changeQueue.add(System.currentTimeMillis());
    }

    public Long processEvents() throws InterruptedException {
        return this.changeQueue.poll(1L, TimeUnit.SECONDS);
    }
}

