/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import com.thoughtworks.xstream.XStream;
import java.util.Map;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.CrossReference;
import org.jbehave.core.reporters.FilePrintStreamFactory;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.web.selenium.SauceContextStoryReporter;
import org.jbehave.web.selenium.SeleniumContext;
import org.jbehave.web.selenium.WebDriverProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SauceContextOutput
extends Format {
    private final WebDriverProvider webDriverProvider;
    private final SeleniumContext seleniumContext;
    private final Map<String, String> storyToSauceUrlMap;

    public SauceContextOutput(WebDriverProvider webDriverProvider, SeleniumContext seleniumContext, Map<String, String> storyToSauceUrlMap) {
        super("SAUCE_CONTEXT");
        this.webDriverProvider = webDriverProvider;
        this.seleniumContext = seleniumContext;
        this.storyToSauceUrlMap = storyToSauceUrlMap;
    }

    public StoryReporter createStoryReporter(FilePrintStreamFactory filePrintStreamFactory, StoryReporterBuilder storyReporterBuilder) {
        return new SauceContextStoryReporter(this.webDriverProvider, this.seleniumContext, this.storyToSauceUrlMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SauceLabsCrossReference
    extends CrossReference {
        protected final transient Map<String, String> storyToSauceUrlMap;

        public SauceLabsCrossReference(Map<String, String> storyToSauceUrlMap) {
            this.storyToSauceUrlMap = storyToSauceUrlMap;
        }

        protected CrossReference.XRefRoot newXRefRoot() {
            return new SauceLabsXRefRoot(this.storyToSauceUrlMap);
        }

        protected void aliasForXRefRoot(XStream xstream) {
            xstream.alias("xref", SauceLabsXRefRoot.class);
        }

        protected void aliasForXRefStory(XStream xstream) {
            xstream.alias("story", SauceLabsXRefStory.class);
        }
    }

    public static class SauceLabsXRefStory
    extends CrossReference.XRefStory {
        private String sauceLabsUrl;

        public SauceLabsXRefStory(Story story, StoryReporterBuilder storyReporterBuilder, boolean passed, boolean pending, String sauceLabsUrl) {
            super(story, storyReporterBuilder, passed, pending);
            this.sauceLabsUrl = sauceLabsUrl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SauceLabsXRefRoot
    extends CrossReference.XRefRoot {
        protected final transient Map<String, String> storyToSauceUrlMap;

        public SauceLabsXRefRoot(Map<String, String> storyToSauceUrlMap) {
            this.storyToSauceUrlMap = storyToSauceUrlMap;
        }

        protected CrossReference.XRefStory createXRefStory(StoryReporterBuilder storyReporterBuilder, Story story, boolean passed, boolean pending) {
            return new SauceLabsXRefStory(story, storyReporterBuilder, passed, pending, this.storyToSauceUrlMap.get(story.getPath()));
        }
    }
}

