/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import org.jbehave.web.selenium.DisplayIdPool;
import org.jbehave.web.selenium.FirefoxWebDriverProvider;
import org.openqa.selenium.firefox.FirefoxBinary;

public class DisplayPoolingFirefoxWebDriverProvider
extends FirefoxWebDriverProvider {
    private DisplayIdPool displayIdPool;
    private ThreadLocal<String> displayScreenId = new ThreadLocal();
    private int refCt = 0;

    public DisplayPoolingFirefoxWebDriverProvider(DisplayIdPool displayPool) {
        this.displayIdPool = displayPool;
    }

    @Override
    protected void decorateFirefoxBinary(FirefoxBinary binary) {
        super.decorateFirefoxBinary(binary);
        String displayID = this.displayIdPool.get();
        this.displayScreenId.set(displayID);
        binary.setEnvironmentProperty("DISPLAY", displayID);
        System.out.println(new StringBuffer("Displays used=").append(++this.refCt).toString());
    }

    @Override
    protected void ending() {
        super.ending();
        String displayId = this.displayScreenId.get();
        this.displayIdPool.returnToPool(displayId);
        System.out.println(new StringBuffer("Displays used=").append(--this.refCt).toString());
    }
}

