/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jbehave.web.selenium.DelegatingWebDriverProvider;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.Response;

public class FirefoxWebDriverProvider
extends DelegatingWebDriverProvider {
    private final WebDriverJournal journal = new WebDriverJournal();
    private static final String JOURNAL_FIREFOX_COMMANDS = System.getProperty("JOURNAL_FIREFOX_COMMANDS", "false");
    public static final String FIREFOX_PROFILE = "JBEHAVE_WEBDRIVER_FIREFOX_PROFILE";

    @Override
    public void initialize() {
        String profileName = System.getProperty(FIREFOX_PROFILE);
        FirefoxBinary binary = new FirefoxBinary();
        this.decorateFirefoxBinary(binary);
        OverriddenFirefoxDriver firefoxDriver = null;
        if (profileName != null) {
            ProfilesIni allProfilesIni = new ProfilesIni();
            FirefoxProfile profile = allProfilesIni.getProfile(profileName);
            profile.setAcceptUntrustedCertificates(false);
            firefoxDriver = new OverriddenFirefoxDriver(binary, profile);
            this.delegate.set(firefoxDriver);
        } else {
            firefoxDriver = null;
            WebDriver[] fireFoxDriverz = new WebDriver[1];
            firefoxDriver = new DoublyOverriddenFirefoxDriver(binary, fireFoxDriverz);
            fireFoxDriverz[0] = firefoxDriver;
            this.delegate.set(firefoxDriver);
        }
        firefoxDriver.setCommandExecutor(new OverridableCommandExecutor(firefoxDriver.getCommandExecutor()));
    }

    public WebDriverJournal getJournal() {
        return this.journal;
    }

    public void clearJournal() {
        this.journal.clear();
    }

    protected void ending() {
    }

    protected void decorateFirefoxBinary(FirefoxBinary binary) {
    }

    private class OverridableCommandExecutor
    implements CommandExecutor {
        private final CommandExecutor realExecutor;
        private Method quitMethod;

        public OverridableCommandExecutor(CommandExecutor realExecutor) {
            this.realExecutor = realExecutor;
            try {
                Class<?> aClass = realExecutor.getClass();
                this.quitMethod = aClass.getDeclaredMethod("quit", new Class[0]);
                this.quitMethod.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response execute(Command command) throws IOException {
            long when = System.currentTimeMillis();
            Response execution = null;
            try {
                execution = this.realExecutor.execute(command);
            }
            finally {
                long dur = System.currentTimeMillis() - when;
                WebDriverJournal webDriverJournal = FirefoxWebDriverProvider.this.journal;
                synchronized (webDriverJournal) {
                    FirefoxWebDriverProvider.this.journal.add(when, dur, command, execution);
                }
            }
            return execution;
        }

        protected void stopClient() {
            try {
                this.quitMethod.invoke((Object)this.realExecutor, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static class WebDriverJournal
    extends ArrayList<Entry> {
        long start = System.currentTimeMillis();

        public void add(long when, long dur, Command command, Response response) {
            if (!JOURNAL_FIREFOX_COMMANDS.equals("false")) {
                this.add(new Entry(when, dur, command, response));
            }
        }

        public class Entry {
            private final long when;
            private final long dur;
            private final Command command;
            private final Response response;

            public Entry(long when, long dur, Command command, Response response) {
                this.when = when;
                this.dur = dur;
                this.command = command;
                this.response = response;
            }

            public String toString() {
                return "" + (this.when - WebDriverJournal.this.start) + " (" + this.dur + "): " + this.command + " -> " + this.response;
            }
        }
    }

    private class DoublyOverriddenFirefoxDriver
    extends OverriddenFirefoxDriver {
        private final WebDriver[] fireFoxDriverz;

        public DoublyOverriddenFirefoxDriver(FirefoxBinary binary, WebDriver[] fireFoxDriverz) {
            super(binary, null);
            this.fireFoxDriverz = fireFoxDriverz;
        }

        @Override
        protected void stopClient() {
            super.stopClient();
            FirefoxWebDriverProvider.this.ending();
        }

        public void close() {
            super.close();
        }
    }

    protected static class OverriddenFirefoxDriver
    extends FirefoxDriver {
        public OverriddenFirefoxDriver(FirefoxBinary binary, FirefoxProfile profile) {
            super(binary, profile);
        }

        public void setCommandExecutor(CommandExecutor executor) {
            super.setCommandExecutor(executor);
        }

        protected void stopClient() {
            ((OverridableCommandExecutor)this.getCommandExecutor()).stopClient();
        }
    }
}

