/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.util.Locale;
import org.jbehave.web.selenium.DelegatingWebDriverProvider;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;

public class PropertyWebDriverProvider
extends DelegatingWebDriverProvider {
    @Override
    public void initialize() {
        Browser browser = Browser.valueOf(Browser.class, System.getProperty("browser", "firefox").toUpperCase(this.usingLocale()));
        this.delegate.set(this.createDriver(browser));
    }

    private WebDriver createDriver(Browser browser) {
        switch (browser) {
            case ANDROID: {
                return this.createAndroidDriver();
            }
            case CHROME: {
                return this.createChromeDriver();
            }
            case FIREFOX: {
                return this.createFirefoxDriver();
            }
            default: {
                return this.createHtmlUnitDriver();
            }
            case IE: {
                return this.createInternetExplorerDriver();
            }
            case PHANTOMJS: 
        }
        return this.createPhantomJSDriver();
    }

    protected WebDriver createAndroidDriver() {
        throw new UnsupportedOperationException("AndroidDriver no longer supported by Selenium.  Use Selendroid instead.");
    }

    protected ChromeDriver createChromeDriver() {
        return new ChromeDriver();
    }

    protected FirefoxDriver createFirefoxDriver() {
        return new FirefoxDriver();
    }

    protected WebDriver createHtmlUnitDriver() {
        HtmlUnitDriver driver = new HtmlUnitDriver();
        boolean javascriptEnabled = Boolean.parseBoolean(System.getProperty("webdriver.htmlunit.javascriptEnabled", "true"));
        driver.setJavascriptEnabled(javascriptEnabled);
        return driver;
    }

    protected InternetExplorerDriver createInternetExplorerDriver() {
        return new InternetExplorerDriver();
    }

    protected WebDriver createPhantomJSDriver() {
        return new PhantomJSDriver();
    }

    protected Locale usingLocale() {
        return Locale.getDefault();
    }

    public static enum Browser {
        ANDROID,
        CHROME,
        FIREFOX,
        HTMLUNIT,
        IE,
        PHANTOMJS;

    }
}

