/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.net.MalformedURLException;
import java.net.URL;
import org.jbehave.web.selenium.RemoteWebDriverProvider;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SauceWebDriverProvider
extends RemoteWebDriverProvider {
    public SauceWebDriverProvider(DesiredCapabilities desiredCapabilities) {
        super(desiredCapabilities);
    }

    public SauceWebDriverProvider() {
    }

    @Override
    protected DesiredCapabilities makeDesiredCapabilities() {
        DesiredCapabilities dc = super.makeDesiredCapabilities();
        dc.setCapability("name", "JBehave");
        dc.setCapability("selenium-version", this.getSeleniumVersion());
        dc.setCapability("max-duration", this.getMaxDuration());
        dc.setCapability("command-timeout", this.getCommandTimeout());
        dc.setCapability("idle-timeout", this.getIdleTimeout());
        return dc;
    }

    protected String getSeleniumVersion() {
        String seVersion = System.getProperty("selenium.version");
        if (seVersion == null) {
            return this.getDefaultSeleniumVersion();
        }
        return seVersion;
    }

    protected String getDefaultSeleniumVersion() {
        return "2.14.0";
    }

    @Override
    public URL createRemoteURL() throws MalformedURLException {
        return new URL("http://" + SauceWebDriverProvider.getSauceCredentials() + "@ondemand.saucelabs.com/wd/hub");
    }

    public static String getSauceUser() {
        String username = System.getProperty("SAUCE_USERNAME");
        if (username == null) {
            throw new UnsupportedOperationException("SAUCE_USERNAME property name variable not specified");
        }
        return username;
    }

    public static String getSauceAccessKey() {
        String access_key = System.getProperty("SAUCE_ACCESS_KEY");
        if (access_key == null) {
            throw new UnsupportedOperationException("SAUCE_ACCESS_KEY property name variable not specified");
        }
        return access_key;
    }

    public static String getSauceCredentials() {
        return SauceWebDriverProvider.getSauceUser() + ":" + SauceWebDriverProvider.getSauceAccessKey();
    }

    protected String getMaxDuration() {
        String maxDuration = System.getProperty("SAUCE_MAX_DURATION");
        if (maxDuration == null) {
            return "1800";
        }
        return maxDuration;
    }

    protected String getCommandTimeout() {
        String commandTimeout = System.getProperty("SAUCE_COMMAND_TIMEOUT");
        if (commandTimeout == null) {
            return "300";
        }
        return commandTimeout;
    }

    protected String getIdleTimeout() {
        String idleTimeout = System.getProperty("SAUCE_IDLE_TIMEOUT");
        if (idleTimeout == null) {
            return "90";
        }
        return idleTimeout;
    }
}

