/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.util.List;
import java.util.Set;
import org.jbehave.web.selenium.WebDriverProvider;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;

public abstract class WebDriverPage
implements WebDriver,
HasInputDevices,
JavascriptExecutor,
HasCapabilities {
    private final WebDriverProvider driverProvider;

    public WebDriverPage(WebDriverProvider driverProvider) {
        this.driverProvider = driverProvider;
    }

    protected WebDriverProvider getDriverProvider() {
        return this.driverProvider;
    }

    protected Actions getActions() {
        return new Actions(this.driverProvider.get());
    }

    public void get(String url) {
        this.driverProvider.get().get(url);
    }

    public String getCurrentUrl() {
        return this.driverProvider.get().getCurrentUrl();
    }

    public String getTitle() {
        return this.driverProvider.get().getTitle();
    }

    public List<WebElement> findElements(By by) {
        return this.driverProvider.get().findElements(by);
    }

    public WebElement findElement(By by) {
        return this.driverProvider.get().findElement(by);
    }

    public String getPageSource() {
        return this.driverProvider.get().getPageSource();
    }

    public void close() {
        this.driverProvider.get().close();
    }

    public void quit() {
        this.driverProvider.get().quit();
    }

    public Set<String> getWindowHandles() {
        return this.driverProvider.get().getWindowHandles();
    }

    public String getWindowHandle() {
        return this.driverProvider.get().getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.driverProvider.get().switchTo();
    }

    public WebDriver.Navigation navigate() {
        return this.driverProvider.get().navigate();
    }

    public WebDriver.Options manage() {
        return this.driverProvider.get().manage();
    }

    public Keyboard getKeyboard() {
        return ((HasInputDevices)this.driverProvider.get()).getKeyboard();
    }

    public Mouse getMouse() {
        return ((HasInputDevices)this.driverProvider.get()).getMouse();
    }

    public Object executeScript(String s, Object ... args) {
        return ((JavascriptExecutor)this.driverProvider.get()).executeScript(s, args);
    }

    public Object executeAsyncScript(String s, Object ... args) {
        return ((JavascriptExecutor)this.driverProvider.get()).executeAsyncScript(s, args);
    }

    public Capabilities getCapabilities() {
        return ((HasCapabilities)this.driverProvider.get()).getCapabilities();
    }
}

