/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.jpa.repository;

import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;
import jakarta.batch.runtime.Metric;
import jakarta.batch.runtime.StepExecution;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jberet.job.model.Job;
import org.jberet.jpa.repository.ExtendedJob;
import org.jberet.jpa.repository.TableColumnsJpa;
import org.jberet.jpa.repository.entity.JobExecutionJpa;
import org.jberet.jpa.repository.entity.JobExecutionJpa_;
import org.jberet.jpa.repository.entity.JobInstanceJpa;
import org.jberet.jpa.repository.entity.JobInstanceJpa_;
import org.jberet.jpa.repository.entity.PartitionExecutionJpa;
import org.jberet.jpa.repository.entity.PartitionExecutionJpa_;
import org.jberet.jpa.repository.entity.StepExecutionJpa;
import org.jberet.jpa.repository.entity.StepExecutionJpa_;
import org.jberet.jpa.util.BatchUtilJpa;
import org.jberet.repository.ApplicationAndJobName;
import org.jberet.repository.JobExecutionSelector;
import org.jberet.repository.JobRepository;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.StepExecutionImpl;

public final class JpaRepository
implements JobRepository {
    public static final String JAKARTA_JPA_LOCK_TIMEOUT = "jakarta.persistence.lock.timeout";
    private final Map<String, Object> hints = new HashMap<String, Object>(){
        {
            this.put(JpaRepository.JAKARTA_JPA_LOCK_TIMEOUT, -2);
        }
    };
    final ConcurrentMap<ApplicationAndJobName, SoftReference<ExtendedJob>> jobs = new ConcurrentHashMap<ApplicationAndJobName, SoftReference<ExtendedJob>>();
    final ReferenceQueue<ExtendedJob> jobReferenceQueue = new ReferenceQueue();
    private final EntityManager entityManager;

    public JpaRepository(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void addJob(ApplicationAndJobName applicationAndJobName, Job job) {
        Reference<ExtendedJob> x;
        ExtendedJob extendedJob = new ExtendedJob();
        extendedJob.setJob(job);
        extendedJob.setApplicationAndJobName(applicationAndJobName);
        while (Objects.nonNull(x = this.jobReferenceQueue.poll()) && Objects.nonNull(x.get())) {
            this.jobs.remove(x.get().getApplicationAndJobName());
        }
        this.jobs.put(applicationAndJobName, new SoftReference<ExtendedJob>(extendedJob, this.jobReferenceQueue));
    }

    public Job getJob(ApplicationAndJobName applicationAndJobName) {
        SoftReference jobSoftReference = (SoftReference)this.jobs.get(applicationAndJobName);
        return Objects.nonNull(jobSoftReference) && Objects.nonNull(jobSoftReference.get()) ? ((ExtendedJob)jobSoftReference.get()).getJob() : null;
    }

    public boolean jobExists(String jobName) {
        return this.jobs.keySet().stream().anyMatch(key -> Objects.equals(key.jobName, jobName));
    }

    public Set<String> getJobNames() {
        return this.jobs.keySet().stream().map(key -> key.appName).collect(Collectors.toSet());
    }

    public void removeJob(String jobId) {
        this.jobs.keySet().stream().filter(key -> Objects.equals(key.jobName, jobId)).forEach(key -> this.jobs.remove(key));
    }

    public JobInstanceImpl createJobInstance(Job job, String applicationName, ClassLoader classLoader) {
        JobInstanceImpl jobInstance = new JobInstanceImpl(job, applicationName, job.getId());
        JobInstanceJpa jobInstanceJpa = new JobInstanceJpa();
        jobInstanceJpa.setJobName(jobInstance.getJobName());
        jobInstanceJpa.setApplicationName(jobInstance.getApplicationName());
        this.entityManager.persist((Object)jobInstanceJpa);
        jobInstance.setId(jobInstanceJpa.getId().longValue());
        return jobInstance;
    }

    public void removeJobInstance(long jobInstanceId) {
        JobInstanceJpa find = (JobInstanceJpa)this.entityManager.find(JobInstanceJpa.class, (Object)jobInstanceId, LockModeType.PESSIMISTIC_WRITE, this.hints);
        if (Objects.nonNull(find)) {
            this.entityManager.remove((Object)find);
        }
    }

    public JobInstance getJobInstance(long jobInstanceId) {
        JobInstanceJpa jobInstanceJpa = (JobInstanceJpa)this.entityManager.find(JobInstanceJpa.class, (Object)jobInstanceId);
        JobInstanceImpl jobInstance = new JobInstanceImpl((Job)Optional.ofNullable((SoftReference)this.jobs.get(new ApplicationAndJobName(jobInstanceJpa.getApplicationName(), jobInstanceJpa.getJobName()))).flatMap(softReference -> Optional.ofNullable((ExtendedJob)softReference.get())).map(extendedJob -> extendedJob.getJob()).orElse(null), jobInstanceJpa.getApplicationName(), jobInstanceJpa.getJobName());
        jobInstance.setId(jobInstanceJpa.getId().longValue());
        return jobInstance;
    }

    public List<JobInstance> getJobInstances(String jobName) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(JobInstanceJpa.class);
        Root root = criteriaQuery.from(JobInstanceJpa.class);
        criteriaQuery.select((Selection)root);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)root.get(JobInstanceJpa_.jobName), (Object)jobName));
        return this.entityManager.createQuery(criteriaQuery).getResultList().stream().map(jobInstanceJpa -> {
            JobInstanceImpl jobInstance = new JobInstanceImpl((Job)Optional.ofNullable((SoftReference)this.jobs.get(new ApplicationAndJobName(jobInstanceJpa.getApplicationName(), jobInstanceJpa.getJobName()))).flatMap(softReference -> Optional.ofNullable((ExtendedJob)softReference.get())).map(extendedJob -> extendedJob.getJob()).orElse(null), jobInstanceJpa.getApplicationName(), jobInstanceJpa.getJobName());
            jobInstance.setId(jobInstanceJpa.getId().longValue());
            return jobInstance;
        }).collect(Collectors.toList());
    }

    public int getJobInstanceCount(String jobName) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root root = criteriaQuery.from(JobInstanceJpa.class);
        criteriaQuery.select((Selection)criteriaBuilder.count((Expression)root));
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)root.get(JobInstanceJpa_.jobName), (Object)jobName));
        return ((Long)this.entityManager.createQuery(criteriaQuery).getSingleResult()).intValue();
    }

    public JobExecutionImpl createJobExecution(JobInstanceImpl jobInstance, Properties jobParameters) {
        JobExecutionImpl jobExecution = new JobExecutionImpl(jobInstance, jobParameters);
        JobExecutionJpa jobExecutionJpa = new JobExecutionJpa();
        jobExecutionJpa.setJobInstance(new JobInstanceJpa());
        jobExecutionJpa.getJobInstance().setId(jobInstance.getInstanceId());
        jobExecutionJpa.setBatchStatus(jobExecution.getBatchStatus());
        jobExecutionJpa.setCreateTime(jobExecution.getCreateTime());
        jobExecutionJpa.setJobParameters(jobExecution.getJobParameters());
        this.entityManager.persist((Object)jobExecutionJpa);
        jobExecution.setId(jobExecutionJpa.getId().longValue());
        return jobExecution;
    }

    public JobExecution getJobExecution(long jobExecutionId) {
        JobExecutionJpa jobExecutionJpa = (JobExecutionJpa)this.entityManager.find(JobExecutionJpa.class, (Object)jobExecutionId);
        return BatchUtilJpa.from(jobExecutionJpa);
    }

    public List<JobExecution> getJobExecutions(JobInstance jobInstance) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(JobExecutionJpa.class);
        Root root = criteriaQuery.from(JobExecutionJpa.class);
        Join join = root.join(JobExecutionJpa_.jobInstance);
        criteriaQuery.select((Selection)root);
        if (Objects.nonNull(jobInstance)) {
            criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)join.get(JobInstanceJpa_.id), (Object)jobInstance.getInstanceId()));
        }
        return this.entityManager.createQuery(criteriaQuery).getResultList().stream().map(jobExecutionJpa -> BatchUtilJpa.from(jobExecutionJpa)).collect(Collectors.toList());
    }

    private List<Long> getJobExecutions(String jobName, boolean runningExecutionsOnly, Integer limit) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root root = criteriaQuery.from(JobExecutionJpa.class);
        Join join = root.join(JobExecutionJpa_.jobInstance);
        criteriaQuery.select((Selection)root.get(JobExecutionJpa_.id));
        criteriaQuery.where((Expression)(runningExecutionsOnly ? criteriaBuilder.and((Expression)root.get(JobExecutionJpa_.batchStatus).in(Arrays.asList(BatchStatus.STARTED, BatchStatus.STARTING)), (Expression)criteriaBuilder.equal((Expression)join.get(JobInstanceJpa_.jobName), (Object)jobName)) : criteriaBuilder.equal((Expression)join.get(JobInstanceJpa_.jobName), (Object)jobName)));
        TypedQuery typedQuery = this.entityManager.createQuery(criteriaQuery);
        if (Objects.nonNull(limit)) {
            typedQuery.setMaxResults(limit.intValue());
        }
        return typedQuery.getResultList();
    }

    public List<Long> getJobExecutionsByJob(String jobName) {
        return this.getJobExecutions(jobName, false, null);
    }

    public List<Long> getJobExecutionsByJob(String jobName, Integer limit) {
        return this.getJobExecutions(jobName, false, limit);
    }

    public List<Long> getRunningExecutions(String jobName) {
        return this.getJobExecutions(jobName, true, null);
    }

    public void updateJobExecution(JobExecutionImpl jobExecution, boolean fullUpdate, boolean saveJobParameters) {
        jobExecution.setLastUpdatedTime(System.currentTimeMillis());
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaUpdate createCriteriaUpdate = criteriaBuilder.createCriteriaUpdate(JobExecutionJpa.class);
        Root root = createCriteriaUpdate.from(JobExecutionJpa.class);
        createCriteriaUpdate.set(root.get(JobExecutionJpa_.batchStatus), (Object)jobExecution.getBatchStatus());
        createCriteriaUpdate.set(root.get(JobExecutionJpa_.lastUpdatedTime), (Object)jobExecution.getLastUpdatedTime());
        if (fullUpdate) {
            createCriteriaUpdate.set(root.get(JobExecutionJpa_.endTime), (Object)jobExecution.getEndTime());
            createCriteriaUpdate.set(root.get(JobExecutionJpa_.exitStatus), (Object)jobExecution.getExitStatus());
            createCriteriaUpdate.set(root.get(JobExecutionJpa_.restartPosition), (Object)jobExecution.combineRestartPositionAndUser());
            if (saveJobParameters) {
                createCriteriaUpdate.set(root.get("jobParameters"), (Object)jobExecution.getJobParameters());
            }
        } else {
            createCriteriaUpdate.set(root.get(JobExecutionJpa_.startTime), (Object)jobExecution.getStartTime());
        }
        createCriteriaUpdate.where((Expression)criteriaBuilder.equal((Expression)root.get(JobExecutionJpa_.id), (Object)jobExecution.getExecutionId()));
        this.entityManager.createQuery(createCriteriaUpdate).executeUpdate();
    }

    private void stopPartitionExecution(JobExecutionImpl jobExecution) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaUpdate createCriteriaUpdate = criteriaBuilder.createCriteriaUpdate(PartitionExecutionJpa.class);
        Root root = createCriteriaUpdate.from(PartitionExecutionJpa.class);
        Subquery subquery = createCriteriaUpdate.subquery(StepExecutionJpa.class);
        Root from = subquery.from(StepExecutionJpa.class);
        subquery.select((Expression)from);
        subquery.where((Expression)criteriaBuilder.equal((Expression)from.get(StepExecutionJpa_.jobExecution).get(JobExecutionJpa_.id), (Object)jobExecution.getExecutionId()));
        createCriteriaUpdate.set(root.get(PartitionExecutionJpa_.batchStatus), (Object)BatchStatus.STOPPING);
        createCriteriaUpdate.where(new Predicate[]{root.get(PartitionExecutionJpa_.stepExecution).in(new Expression[]{subquery.getSelection()}), criteriaBuilder.equal((Expression)root.get(PartitionExecutionJpa_.batchStatus), (Object)BatchStatus.STARTED)});
        this.entityManager.createQuery(createCriteriaUpdate).executeUpdate();
    }

    private void stopStepExecution(JobExecutionImpl jobExecution) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaUpdate createCriteriaUpdate = criteriaBuilder.createCriteriaUpdate(StepExecutionJpa.class);
        Root root = createCriteriaUpdate.from(StepExecutionJpa.class);
        createCriteriaUpdate.set(root.get(StepExecutionJpa_.batchStatus), (Object)BatchStatus.STOPPING);
        createCriteriaUpdate.where(new Predicate[]{criteriaBuilder.equal((Expression)root.get(StepExecutionJpa_.jobExecution).get(JobExecutionJpa_.id), (Object)jobExecution.getExecutionId()), criteriaBuilder.equal((Expression)root.get(StepExecutionJpa_.batchStatus), (Object)BatchStatus.STARTED)});
        this.entityManager.createQuery(createCriteriaUpdate).executeUpdate();
        this.stopPartitionExecution(jobExecution);
    }

    public void stopJobExecution(JobExecutionImpl jobExecution) {
        jobExecution.setLastUpdatedTime(System.currentTimeMillis());
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaUpdate createCriteriaUpdate = criteriaBuilder.createCriteriaUpdate(JobExecutionJpa.class);
        Root root = createCriteriaUpdate.from(JobExecutionJpa.class);
        createCriteriaUpdate.set(root.get(JobExecutionJpa_.batchStatus), (Object)BatchStatus.STOPPING);
        createCriteriaUpdate.set(root.get(JobExecutionJpa_.lastUpdatedTime), (Object)jobExecution.getLastUpdatedTime());
        createCriteriaUpdate.where(new Predicate[]{criteriaBuilder.equal((Expression)root.get(JobExecutionJpa_.id), (Object)jobExecution.getExecutionId()), criteriaBuilder.equal((Expression)root.get(JobExecutionJpa_.batchStatus), (Object)BatchStatus.STARTED)});
        this.entityManager.createQuery(createCriteriaUpdate).executeUpdate();
        this.stopStepExecution(jobExecution);
    }

    public JobExecutionJpa getNextUnlocked(Integer offset) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(JobExecutionJpa.class);
        Root from = criteriaQuery.from(JobExecutionJpa.class);
        criteriaQuery.select((Selection)from);
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)from.get(JobExecutionJpa_.createTime))});
        TypedQuery createQuery = this.entityManager.createQuery(criteriaQuery);
        createQuery.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        createQuery.setHint(JAKARTA_JPA_LOCK_TIMEOUT, (Object)-2);
        createQuery.setFirstResult(offset.intValue());
        createQuery.setMaxResults(1);
        return createQuery.getResultList().stream().findFirst().orElse(null);
    }

    public void removeJobExecutions(JobExecutionSelector jobExecutionSelector) {
        JobExecutionJpa jobExecution;
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(JobExecutionJpa.class);
        criteriaQuery.select((Selection)criteriaQuery.from(JobExecutionJpa.class));
        Set jobExecutionIds = this.entityManager.createQuery(criteriaQuery).getResultList().stream().map(JobExecutionJpa::getId).collect(Collectors.toSet());
        Integer offset = 0;
        while (Objects.nonNull(jobExecution = this.getNextUnlocked(offset))) {
            if (Objects.isNull(jobExecutionSelector) || jobExecutionSelector.select((JobExecution)jobExecution, jobExecutionIds)) {
                this.entityManager.remove((Object)jobExecution);
                continue;
            }
            offset = offset + 1;
        }
    }

    public List<StepExecution> getStepExecutions(long jobExecutionId, ClassLoader classLoader) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(StepExecutionJpa.class);
        Root root = criteriaQuery.from(StepExecutionJpa.class);
        criteriaQuery.select((Selection)root);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)root.get(StepExecutionJpa_.jobExecution).get(JobExecutionJpa_.id), (Object)jobExecutionId));
        return this.entityManager.createQuery(criteriaQuery).getResultList().stream().map(stepExecutionJpa -> BatchUtilJpa.from(stepExecutionJpa)).collect(Collectors.toList());
    }

    public StepExecutionImpl createStepExecution(String stepName) {
        return new StepExecutionImpl(stepName);
    }

    public void addStepExecution(JobExecutionImpl jobExecution, StepExecutionImpl stepExecution) {
        jobExecution.addStepExecution((StepExecution)stepExecution);
        StepExecutionJpa stepExecutionJpa = new StepExecutionJpa();
        stepExecutionJpa.setStepName(stepExecution.getStepName());
        stepExecutionJpa.setBatchStatus(stepExecution.getBatchStatus());
        stepExecutionJpa.setStartTime(stepExecution.getStartTime());
        stepExecutionJpa.setJobExecution(new JobExecutionJpa());
        stepExecutionJpa.getJobExecution().setId(jobExecution.getExecutionId());
        this.entityManager.persist((Object)stepExecutionJpa);
        stepExecution.setId(stepExecutionJpa.getId().longValue());
    }

    private int updateStepExecution(StepExecution stepExecution, boolean notStopping) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaUpdate createCriteriaUpdate = criteriaBuilder.createCriteriaUpdate(StepExecutionJpa.class);
        Root root = createCriteriaUpdate.from(StepExecutionJpa.class);
        Path versionPath = root.get(StepExecutionJpa_.version);
        createCriteriaUpdate.set(versionPath, criteriaBuilder.sum((Expression)versionPath, (Number)1L));
        createCriteriaUpdate.set(root.get(StepExecutionJpa_.endTime), (Object)stepExecution.getEndTime());
        createCriteriaUpdate.set(root.get(StepExecutionJpa_.batchStatus), (Object)stepExecution.getBatchStatus());
        createCriteriaUpdate.set(root.get(StepExecutionJpa_.exitStatus), (Object)stepExecution.getExitStatus());
        if (stepExecution instanceof AbstractStepExecution) {
            AbstractStepExecution abstractStepExecution = (AbstractStepExecution)AbstractStepExecution.class.cast(stepExecution);
            createCriteriaUpdate.set(root.get(StepExecutionJpa_.executionException), (Object)TableColumnsJpa.formatException(abstractStepExecution.getException()));
            createCriteriaUpdate.set(root.get(StepExecutionJpa_.persistenUserData), (Object)abstractStepExecution.getPersistentUserDataSerialized());
            createCriteriaUpdate.set(root.get(StepExecutionJpa_.readCount), (Object)abstractStepExecution.getStepMetrics().get(Metric.MetricType.READ_COUNT));
            createCriteriaUpdate.set(root.get(StepExecutionJpa_.writeCount), (Object)abstractStepExecution.getStepMetrics().get(Metric.MetricType.WRITE_COUNT));
            createCriteriaUpdate.set(root.get(StepExecutionJpa_.commitCount), (Object)abstractStepExecution.getStepMetrics().get(Metric.MetricType.COMMIT_COUNT));
            createCriteriaUpdate.set(root.get(StepExecutionJpa_.rollbackCount), (Object)abstractStepExecution.getStepMetrics().get(Metric.MetricType.ROLLBACK_COUNT));
            createCriteriaUpdate.set(root.get(StepExecutionJpa_.readSkipCount), (Object)abstractStepExecution.getStepMetrics().get(Metric.MetricType.READ_SKIP_COUNT));
            createCriteriaUpdate.set(root.get(StepExecutionJpa_.processSkipCount), (Object)abstractStepExecution.getStepMetrics().get(Metric.MetricType.PROCESS_SKIP_COUNT));
            createCriteriaUpdate.set(root.get(StepExecutionJpa_.filterCount), (Object)abstractStepExecution.getStepMetrics().get(Metric.MetricType.FILTER_COUNT));
            createCriteriaUpdate.set(root.get(StepExecutionJpa_.writeSkipCount), (Object)abstractStepExecution.getStepMetrics().get(Metric.MetricType.WRITE_SKIP_COUNT));
            createCriteriaUpdate.set(root.get(StepExecutionJpa_.readerCheckPointInfo), (Object)abstractStepExecution.getReaderCheckpointInfoSerialized());
            createCriteriaUpdate.set(root.get(StepExecutionJpa_.writerCheckPointInfo), (Object)abstractStepExecution.getWriterCheckpointInfoSerialized());
        }
        createCriteriaUpdate.where((Expression)(notStopping ? criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(StepExecutionJpa_.id), (Object)stepExecution.getStepExecutionId()), (Expression)criteriaBuilder.notEqual((Expression)root.get(StepExecutionJpa_.batchStatus), (Object)BatchStatus.STOPPED)) : criteriaBuilder.equal((Expression)root.get(StepExecutionJpa_.id), (Object)stepExecution.getStepExecutionId())));
        return this.entityManager.createQuery(createCriteriaUpdate).executeUpdate();
    }

    public void updateStepExecution(StepExecution stepExecution) {
        this.updateStepExecution(stepExecution, false);
    }

    public void addPartitionExecution(StepExecutionImpl enclosingStepExecution, PartitionExecutionImpl partitionExecution) {
        enclosingStepExecution.getPartitionExecutions().add(partitionExecution);
        PartitionExecutionJpa partitionExecutionJpa = new PartitionExecutionJpa();
        partitionExecutionJpa.setId(Long.valueOf(partitionExecution.getPartitionId()));
        partitionExecutionJpa.setStepExecution(new StepExecutionJpa());
        partitionExecutionJpa.getStepExecution().setId(partitionExecution.getStepExecutionId());
        partitionExecutionJpa.setBatchStatus(partitionExecution.getBatchStatus());
        this.entityManager.persist((Object)partitionExecutionJpa);
    }

    public StepExecutionImpl findOriginalStepExecutionForRestart(String stepName, JobExecutionImpl jobExecutionToRestart, ClassLoader classLoader) {
        return jobExecutionToRestart.getStepExecutions().stream().filter(stepExecution -> Objects.equals(stepName, stepExecution.getStepName()) && stepExecution instanceof StepExecutionImpl).map(stepExecution -> (StepExecutionImpl)StepExecutionImpl.class.cast(stepExecution)).findFirst().orElseGet(() -> {
            CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(StepExecutionJpa.class);
            Root root = criteriaQuery.from(StepExecutionJpa.class);
            criteriaQuery.select((Selection)root);
            criteriaQuery.where(new Predicate[]{criteriaBuilder.equal((Expression)root.get(StepExecutionJpa_.jobExecution).get(JobExecutionJpa_.jobInstance).get(JobInstanceJpa_.id), (Object)jobExecutionToRestart.getJobInstance().getInstanceId()), criteriaBuilder.equal((Expression)root.get(StepExecutionJpa_.stepName), (Object)stepName)});
            criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(StepExecutionJpa_.id))});
            TypedQuery createQuery = this.entityManager.createQuery(criteriaQuery);
            createQuery.setMaxResults(1);
            return BatchUtilJpa.from((StepExecutionJpa)createQuery.getSingleResult());
        });
    }

    public List<PartitionExecutionImpl> getPartitionExecutions(long stepExecutionId, StepExecutionImpl stepExecution, boolean notCompletedOnly, ClassLoader classLoader) {
        return Optional.ofNullable(stepExecution).map(value -> Optional.ofNullable(value.getPartitionExecutions()).orElse(Collections.emptyList())).map(partitionExecutions -> partitionExecutions.isEmpty() || !notCompletedOnly ? partitionExecutions : partitionExecutions.stream().filter(sei -> !BatchStatus.COMPLETED.equals((Object)sei.getBatchStatus())).collect(Collectors.toList())).filter(result -> !result.isEmpty()).orElseGet(() -> {
            CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(PartitionExecutionJpa.class);
            Root root = criteriaQuery.from(PartitionExecutionJpa.class);
            criteriaQuery.select((Selection)root);
            criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)root.get(PartitionExecutionJpa_.stepExecution).get(StepExecutionJpa_.id), (Object)stepExecutionId));
            criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get(PartitionExecutionJpa_.id))});
            return this.entityManager.createQuery(criteriaQuery).getResultList().stream().filter(partitionExecutionJpa -> !notCompletedOnly || !BatchStatus.COMPLETED.equals((Object)partitionExecutionJpa.getBatchStatus())).map(partitionExecutionJpa -> BatchUtilJpa.from(partitionExecutionJpa)).collect(Collectors.toList());
        });
    }

    public int countStepStartTimes(String stepName, long jobInstanceId) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root root = criteriaQuery.from(StepExecutionJpa.class);
        criteriaQuery.select((Selection)criteriaBuilder.countDistinct((Expression)root.get(StepExecutionJpa_.id)));
        criteriaQuery.where(new Predicate[]{criteriaBuilder.equal((Expression)root.get(StepExecutionJpa_.jobExecution).get(JobExecutionJpa_.jobInstance).get(JobInstanceJpa_.id), (Object)jobInstanceId), criteriaBuilder.equal((Expression)root.get(StepExecutionJpa_.stepName), (Object)stepName)});
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(StepExecutionJpa_.id))});
        return ((Long)this.entityManager.createQuery(criteriaQuery).getSingleResult()).intValue();
    }

    private int updatePartitionExecution(PartitionExecutionImpl partitionExecutionImpl, boolean notStopping) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaUpdate createCriteriaUpdate = criteriaBuilder.createCriteriaUpdate(PartitionExecutionJpa.class);
        Root root = createCriteriaUpdate.from(PartitionExecutionJpa.class);
        Path versionPath = root.get(PartitionExecutionJpa_.version);
        createCriteriaUpdate.set(versionPath, criteriaBuilder.sum((Expression)versionPath, (Number)1L));
        createCriteriaUpdate.set(root.get(PartitionExecutionJpa_.batchStatus), (Object)partitionExecutionImpl.getBatchStatus());
        createCriteriaUpdate.set(root.get(PartitionExecutionJpa_.exitStatus), (Object)partitionExecutionImpl.getExitStatus());
        createCriteriaUpdate.set(root.get(PartitionExecutionJpa_.executionException), (Object)TableColumnsJpa.formatException(partitionExecutionImpl.getException()));
        createCriteriaUpdate.set(root.get(PartitionExecutionJpa_.persistenUserData), (Object)partitionExecutionImpl.getPersistentUserDataSerialized());
        createCriteriaUpdate.set(root.get(PartitionExecutionJpa_.readerCheckPointInfo), (Object)partitionExecutionImpl.getReaderCheckpointInfoSerialized());
        createCriteriaUpdate.set(root.get(PartitionExecutionJpa_.writerCheckPointInfo), (Object)partitionExecutionImpl.getWriterCheckpointInfoSerialized());
        createCriteriaUpdate.where((Expression)(notStopping ? criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get(PartitionExecutionJpa_.id), (Object)partitionExecutionImpl.getPartitionId()), criteriaBuilder.equal((Expression)root.get(PartitionExecutionJpa_.stepExecution).get(StepExecutionJpa_.id), (Object)partitionExecutionImpl.getStepExecutionId()), criteriaBuilder.notEqual((Expression)root.get(PartitionExecutionJpa_.batchStatus), (Object)BatchStatus.STOPPED)}) : criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(PartitionExecutionJpa_.id), (Object)partitionExecutionImpl.getPartitionId()), (Expression)criteriaBuilder.equal((Expression)root.get(PartitionExecutionJpa_.stepExecution).get(StepExecutionJpa_.id), (Object)partitionExecutionImpl.getStepExecutionId()))));
        return this.entityManager.createQuery(createCriteriaUpdate).executeUpdate();
    }

    public void savePersistentData(JobExecution jobExecution, AbstractStepExecution stepOrPartitionExecution) {
        if (stepOrPartitionExecution instanceof StepExecutionImpl) {
            this.updateStepExecution((StepExecution)stepOrPartitionExecution, false);
        } else if (stepOrPartitionExecution instanceof PartitionExecutionImpl) {
            this.updatePartitionExecution((PartitionExecutionImpl)PartitionExecutionImpl.class.cast(stepOrPartitionExecution), false);
        }
    }

    public int savePersistentDataIfNotStopping(JobExecution jobExecution, AbstractStepExecution stepOrPartitionExecution) {
        if (stepOrPartitionExecution instanceof StepExecutionImpl) {
            return this.updateStepExecution((StepExecution)stepOrPartitionExecution, true);
        }
        return this.updatePartitionExecution((PartitionExecutionImpl)PartitionExecutionImpl.class.cast(stepOrPartitionExecution), true);
    }
}

