/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.jpa.repository.entity;

import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import org.jberet.jpa.repository.PropertiesConverter;
import org.jberet.jpa.repository.entity.JobInstanceJpa;
import org.jberet.jpa.repository.entity.StepExecutionJpa;

@Entity
@Table(name="JOB_EXECUTION")
public class JobExecutionJpa
implements Serializable,
JobExecution {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="JOBEXECUTIONID")
    private Long id;
    @Column(name="VERSION")
    private Long version;
    @ManyToOne
    @JoinColumn(name="JOBINSTANCEID", nullable=false)
    private JobInstanceJpa jobInstance;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATETIME")
    private Date createTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="STARTTIME")
    private Date startTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ENDTIME")
    private Date endTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="LASTUPDATEDTIME")
    private Date lastUpdatedTime;
    @Enumerated(value=EnumType.STRING)
    @Column(name="BATCHSTATUS")
    private BatchStatus batchStatus;
    @Column(name="EXITSTATUS")
    private String exitStatus;
    @Convert(converter=PropertiesConverter.class)
    @Column(name="JOBPARAMETERS")
    private Properties jobParameters;
    @Column(name="RESTARTPOSITION")
    private String restartPosition;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="jobExecution", cascade={CascadeType.REMOVE}, orphanRemoval=true)
    private Collection<StepExecutionJpa> stepExecutions = new ArrayList<StepExecutionJpa>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public JobInstanceJpa getJobInstance() {
        return this.jobInstance;
    }

    public void setJobInstance(JobInstanceJpa jobInstance) {
        this.jobInstance = jobInstance;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    public void setBatchStatus(BatchStatus batchStatus) {
        this.batchStatus = batchStatus;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
    }

    public Properties getJobParameters() {
        return this.jobParameters;
    }

    public void setJobParameters(Properties jobParameters) {
        this.jobParameters = jobParameters;
    }

    public String getRestartPosition() {
        return this.restartPosition;
    }

    public void setRestartPosition(String restartPosition) {
        this.restartPosition = restartPosition;
    }

    public long getExecutionId() {
        return this.getId();
    }

    public String getJobName() {
        return this.jobInstance.getJobName();
    }

    public Collection<StepExecutionJpa> getStepExecutions() {
        return this.stepExecutions;
    }

    public void setStepExecutions(Collection<StepExecutionJpa> stepExecutions) {
        this.stepExecutions = stepExecutions;
    }
}

