/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.schedule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.jberet.schedule.JobSchedule;
import org.jberet.schedule.JobScheduleConfig;
import org.jberet.schedule.JobScheduleTask;
import org.jberet.schedule.JobScheduler;

public class ExecutorSchedulerImpl
extends JobScheduler {
    protected final ScheduledExecutorService executorService;
    private final ConcurrentMap<String, JobSchedule> schedules;
    private final AtomicInteger ids = new AtomicInteger(1);

    public ExecutorSchedulerImpl() {
        this(null);
    }

    public ExecutorSchedulerImpl(ConcurrentMap<String, JobSchedule> schedules) {
        this(schedules, null);
    }

    public ExecutorSchedulerImpl(ConcurrentMap<String, JobSchedule> schedules, ScheduledExecutorService executorService) {
        this.schedules = schedules == null ? new ConcurrentHashMap() : schedules;
        this.executorService = executorService == null ? Executors.newSingleThreadScheduledExecutor() : executorService;
    }

    @Override
    public JobSchedule schedule(JobScheduleConfig scheduleConfig) {
        JobSchedule jobSchedule = new JobSchedule(String.valueOf(this.ids.getAndIncrement()), scheduleConfig);
        JobScheduleTask task = new JobScheduleTask(jobSchedule);
        ScheduledFuture<?> future = scheduleConfig.interval <= 0L && scheduleConfig.afterDelay <= 0L ? this.executorService.schedule(task, scheduleConfig.initialDelay, timeUnit) : (scheduleConfig.interval > 0L ? this.executorService.scheduleAtFixedRate(task, scheduleConfig.initialDelay, scheduleConfig.interval, timeUnit) : this.executorService.scheduleWithFixedDelay(task, scheduleConfig.initialDelay, scheduleConfig.afterDelay, timeUnit));
        jobSchedule.setFuture(future);
        this.schedules.put(jobSchedule.getId(), jobSchedule);
        return jobSchedule;
    }

    @Override
    public List<JobSchedule> getJobSchedules() {
        ArrayList<JobSchedule> result = new ArrayList<JobSchedule>();
        for (JobSchedule e : this.schedules.values()) {
            Future<?> future;
            JobSchedule.Status status = e.getStatus();
            if (status != JobSchedule.Status.CANCELLED && status != JobSchedule.Status.DONE && (future = e.getFuture()) != null) {
                if (future.isCancelled()) {
                    e.setStatus(JobSchedule.Status.CANCELLED);
                } else if (future.isDone()) {
                    e.setStatus(JobSchedule.Status.DONE);
                }
            }
            result.add(e);
        }
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    @Override
    public boolean cancel(String scheduleId) {
        boolean result = false;
        JobSchedule jobSchedule = (JobSchedule)this.schedules.get(scheduleId);
        if (jobSchedule != null) {
            JobSchedule.Status status = jobSchedule.getStatus();
            if (status == JobSchedule.Status.DONE || status == JobSchedule.Status.CANCELLED) {
                return false;
            }
            Future<?> future = jobSchedule.getFuture();
            if (future != null && (result = future.cancel(true))) {
                jobSchedule.setStatus(JobSchedule.Status.CANCELLED);
            }
        }
        return result;
    }

    @Override
    public void delete(String scheduleId) {
        super.delete(scheduleId);
        this.schedules.remove(scheduleId);
    }

    @Override
    public JobSchedule getJobSchedule(String scheduleId) {
        Future<?> future;
        JobSchedule.Status status;
        JobSchedule jobSchedule = (JobSchedule)this.schedules.get(scheduleId);
        if (jobSchedule != null && (status = jobSchedule.getStatus()) != JobSchedule.Status.CANCELLED && status != JobSchedule.Status.DONE && (future = jobSchedule.getFuture()) != null) {
            if (future.isCancelled()) {
                jobSchedule.setStatus(JobSchedule.Status.CANCELLED);
            } else if (future.isDone()) {
                jobSchedule.setStatus(JobSchedule.Status.DONE);
            }
        }
        return jobSchedule;
    }

    public String toString() {
        return this.getClass().getName() + "{executorService=" + this.executorService + "}";
    }
}

