/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.schedule;

import jakarta.ejb.ScheduleExpression;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Properties;
import org.jberet.schedule._private.ScheduleExpressionAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class JobScheduleConfig
implements Serializable {
    private static final long serialVersionUID = 7225109864510680914L;
    String jobName;
    long jobExecutionId;
    final Properties jobParameters;
    @XmlJavaTypeAdapter(value=ScheduleExpressionAdapter.class)
    final ScheduleExpression scheduleExpression;
    final long initialDelay;
    final long afterDelay;
    final long interval;
    final boolean persistent;

    public JobScheduleConfig() {
        this(null, 0L, null, null, 0L, 0L, 0L, false);
    }

    JobScheduleConfig(String jobName, long jobExecutionId, Properties jobParameters, ScheduleExpression scheduleExpression, long initialDelay, long afterDelay, long interval, boolean persistent) {
        this.jobName = jobName;
        this.jobExecutionId = jobExecutionId;
        this.jobParameters = jobParameters;
        this.scheduleExpression = scheduleExpression;
        this.initialDelay = initialDelay;
        this.afterDelay = afterDelay;
        this.interval = interval;
        this.persistent = persistent;
    }

    public boolean isRepeating() {
        return this.afterDelay > 0L || this.interval > 0L || this.scheduleExpression != null;
    }

    public String getJobName() {
        return this.jobName;
    }

    public long getJobExecutionId() {
        return this.jobExecutionId;
    }

    public Properties getJobParameters() {
        return this.jobParameters;
    }

    public ScheduleExpression getScheduleExpression() {
        return this.scheduleExpression;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public long getAfterDelay() {
        return this.afterDelay;
    }

    public long getInterval() {
        return this.interval;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setJobExecutionId(long jobExecutionId) {
        this.jobExecutionId = jobExecutionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobScheduleConfig that = (JobScheduleConfig)o;
        if (this.jobExecutionId != that.jobExecutionId) {
            return false;
        }
        if (this.initialDelay != that.initialDelay) {
            return false;
        }
        if (this.afterDelay != that.afterDelay) {
            return false;
        }
        if (this.interval != that.interval) {
            return false;
        }
        if (this.persistent != that.persistent) {
            return false;
        }
        if (this.jobName != null ? !this.jobName.equals(that.jobName) : that.jobName != null) {
            return false;
        }
        if (this.jobParameters != null ? !this.jobParameters.equals(that.jobParameters) : that.jobParameters != null) {
            return false;
        }
        return this.scheduleExpression != null ? this.scheduleExpression.equals(that.scheduleExpression) : that.scheduleExpression == null;
    }

    public int hashCode() {
        int result = this.jobName != null ? this.jobName.hashCode() : 0;
        result = 31 * result + (int)(this.jobExecutionId ^ this.jobExecutionId >>> 32);
        result = 31 * result + (this.jobParameters != null ? this.jobParameters.hashCode() : 0);
        result = 31 * result + (this.scheduleExpression != null ? this.scheduleExpression.hashCode() : 0);
        result = 31 * result + (int)(this.initialDelay ^ this.initialDelay >>> 32);
        result = 31 * result + (int)(this.afterDelay ^ this.afterDelay >>> 32);
        result = 31 * result + (int)(this.interval ^ this.interval >>> 32);
        result = 31 * result + (this.persistent ? 1 : 0);
        return result;
    }

    public String toString() {
        return "JobScheduleInfo{jobName='" + this.jobName + "', jobExecutionId=" + this.jobExecutionId + ", jobParameters=" + this.jobParameters + ", initialDelay=" + this.initialDelay + ", afterDelay=" + this.afterDelay + ", interval=" + this.interval + ", persistent=" + this.persistent + ", scheduleExpression='" + this.scheduleExpression + "'}";
    }
}

