/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.se;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.jberet.se.BatchThreadFactory;
import org.jberet.se.SEArtifactFactory;
import org.jberet.se._private.SEBatchLogger;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.tx.LocalTransactionManager;

public final class BatchSEEnvironment
implements BatchEnvironment {
    ExecutorService executorService;
    public static final String CONFIG_FILE_NAME = "jberet.properties";
    private final Properties configProperties = new Properties();
    private final TransactionManager tm;
    static final String THREAD_POOL_TYPE = "thread-pool-type";
    static final String THREAD_POOL_TYPE_CACHED = "Cached";
    static final String THREAD_POOL_TYPE_FIXED = "Fixed";
    static final String THREAD_POOL_TYPE_CONFIGURED = "Configured";
    static final String THREAD_POOL_CORE_SIZE = "thread-pool-core-size";
    static final String THREAD_POOL_MAX_SIZE = "thread-pool-max-size";
    static final String THREAD_POOL_KEEP_ALIVE_TIME = "thread-pool-keep-alive-time";
    static final String THREAD_POOL_QUEUE_CAPACITY = "thread-pool-queue-capacity";
    static final String THREAD_POOL_ALLOW_CORE_THREAD_TIMEOUT = "thread-pool-allow-core-thread-timeout";
    static final String THREAD_POOL_PRESTART_ALL_CORE_THREADS = "thread-pool-prestart-all-core-threads";
    static final String THREAD_POOL_REJECTION_POLICY = "thread-pool-rejection-policy";
    static final String THREAD_FACTORY = "thread-factory";

    public BatchSEEnvironment() {
        InputStream configStream = this.getClassLoader().getResourceAsStream(CONFIG_FILE_NAME);
        if (configStream != null) {
            try {
                this.configProperties.load(configStream);
            }
            catch (IOException e) {
                throw SEBatchLogger.LOGGER.failToLoadConfig(e, CONFIG_FILE_NAME);
            }
        } else {
            SEBatchLogger.LOGGER.useDefaultJBeretConfig(CONFIG_FILE_NAME);
        }
        this.tm = LocalTransactionManager.getInstance();
        this.createThreadPoolExecutor();
    }

    public ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = BatchSEEnvironment.class.getClassLoader();
        }
        return cl;
    }

    public ArtifactFactory getArtifactFactory() {
        return new SEArtifactFactory();
    }

    public Future<?> submitTask(Runnable task) {
        return this.executorService.submit(task);
    }

    public <T> Future<T> submitTask(Runnable task, T result) {
        return this.executorService.submit(task, result);
    }

    public <T> Future<T> submitTask(Callable<T> task) {
        return this.executorService.submit(task);
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public Properties getBatchConfigurationProperties() {
        return this.configProperties;
    }

    void createThreadPoolExecutor() {
        int coreSize;
        ThreadFactory threadFactory;
        String threadPoolType = this.configProperties.getProperty(THREAD_POOL_TYPE);
        String threadFactoryProp = this.configProperties.getProperty(THREAD_FACTORY);
        if (threadFactoryProp != null && !threadFactoryProp.isEmpty()) {
            try {
                Class<?> threadFactoryClass = this.getClassLoader().loadClass(threadFactoryProp.trim());
                threadFactory = (ThreadFactory)threadFactoryClass.newInstance();
            }
            catch (Exception e) {
                throw SEBatchLogger.LOGGER.failToGetConfigProperty(THREAD_FACTORY, threadFactoryProp, e);
            }
        } else {
            threadFactory = new BatchThreadFactory();
        }
        if (threadPoolType == null || threadPoolType.isEmpty() || threadPoolType.trim().equalsIgnoreCase(THREAD_POOL_TYPE_CACHED)) {
            this.executorService = Executors.newCachedThreadPool(threadFactory);
            return;
        }
        String coreSizeProp = this.configProperties.getProperty(THREAD_POOL_CORE_SIZE);
        try {
            coreSize = Integer.parseInt(coreSizeProp.trim());
        }
        catch (Exception e) {
            throw SEBatchLogger.LOGGER.failToGetConfigProperty(THREAD_POOL_CORE_SIZE, coreSizeProp, e);
        }
        threadPoolType = threadPoolType.trim();
        if (threadPoolType.equalsIgnoreCase(THREAD_POOL_TYPE_FIXED)) {
            this.executorService = Executors.newFixedThreadPool(coreSize, threadFactory);
            return;
        }
        if (threadPoolType.equalsIgnoreCase(THREAD_POOL_TYPE_CONFIGURED)) {
            ThreadPoolExecutor threadPoolExecutor;
            int queueCapacity;
            long keepAliveSeconds;
            int maxSize;
            String maxSizeProp = this.configProperties.getProperty(THREAD_POOL_MAX_SIZE);
            try {
                maxSize = Integer.parseInt(maxSizeProp.trim());
            }
            catch (Exception e) {
                throw SEBatchLogger.LOGGER.failToGetConfigProperty(THREAD_POOL_MAX_SIZE, maxSizeProp, e);
            }
            String keepAliveProp = this.configProperties.getProperty(THREAD_POOL_KEEP_ALIVE_TIME);
            try {
                keepAliveSeconds = Long.parseLong(keepAliveProp.trim());
            }
            catch (Exception e) {
                throw SEBatchLogger.LOGGER.failToGetConfigProperty(THREAD_POOL_KEEP_ALIVE_TIME, keepAliveProp, e);
            }
            String queueCapacityProp = this.configProperties.getProperty(THREAD_POOL_QUEUE_CAPACITY);
            try {
                queueCapacity = Integer.parseInt(queueCapacityProp.trim());
            }
            catch (Exception e) {
                throw SEBatchLogger.LOGGER.failToGetConfigProperty(THREAD_POOL_QUEUE_CAPACITY, queueCapacityProp, e);
            }
            String allowCoreThreadTimeoutProp = this.configProperties.getProperty(THREAD_POOL_ALLOW_CORE_THREAD_TIMEOUT);
            boolean allowCoreThreadTimeout = allowCoreThreadTimeoutProp == null || allowCoreThreadTimeoutProp.isEmpty() ? false : Boolean.parseBoolean(allowCoreThreadTimeoutProp.trim());
            String prestartAllCoreThreadsProp = this.configProperties.getProperty(THREAD_POOL_PRESTART_ALL_CORE_THREADS);
            boolean prestartAllCoreThreads = prestartAllCoreThreadsProp == null || prestartAllCoreThreadsProp.isEmpty() ? false : Boolean.parseBoolean(prestartAllCoreThreadsProp.trim());
            BlockingQueue workQueue = (BlockingQueue)((Object)(queueCapacity > 0 ? new LinkedBlockingQueue(queueCapacity) : new SynchronousQueue(true)));
            String rejectionPolicyProp = this.configProperties.getProperty(THREAD_POOL_REJECTION_POLICY);
            RejectedExecutionHandler rejectionHandler = null;
            if (rejectionPolicyProp != null && !rejectionPolicyProp.isEmpty()) {
                try {
                    Class<?> aClass = this.getClassLoader().loadClass(rejectionPolicyProp.trim());
                    rejectionHandler = (RejectedExecutionHandler)aClass.newInstance();
                }
                catch (Exception e) {
                    throw SEBatchLogger.LOGGER.failToGetConfigProperty(THREAD_POOL_REJECTION_POLICY, rejectionPolicyProp, e);
                }
            }
            ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor = rejectionHandler == null ? new ThreadPoolExecutor(coreSize, maxSize, keepAliveSeconds, TimeUnit.SECONDS, (BlockingQueue<Runnable>)workQueue, threadFactory) : new ThreadPoolExecutor(coreSize, maxSize, keepAliveSeconds, TimeUnit.SECONDS, workQueue, threadFactory, rejectionHandler);
            if (allowCoreThreadTimeout) {
                threadPoolExecutor.allowCoreThreadTimeOut(true);
            }
            if (prestartAllCoreThreads) {
                threadPoolExecutor.prestartAllCoreThreads();
            }
            this.executorService = threadPoolExecutor;
            return;
        }
        throw SEBatchLogger.LOGGER.failToGetConfigProperty(THREAD_POOL_TYPE, threadPoolType, null);
    }
}

