/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.CsvItemReaderWriterBase;
import org.jberet.support.io.FastForwardCsvBeanReader;
import org.jberet.support.io.FastForwardCsvListReader;
import org.jberet.support.io.FastForwardCsvMapReader;
import org.supercsv.io.ICsvBeanReader;
import org.supercsv.io.ICsvListReader;
import org.supercsv.io.ICsvMapReader;
import org.supercsv.io.ICsvReader;

@Named
@Dependent
public class CsvItemReader
extends CsvItemReaderWriterBase
implements ItemReader {
    @Inject
    @BatchProperty
    protected int start;
    @Inject
    @BatchProperty
    protected int end;
    @Inject
    @BatchProperty
    protected boolean headerless;
    protected ICsvReader delegateReader;

    public void open(Serializable checkpoint) {
        int startRowNumber;
        if (this.end == 0) {
            this.end = Integer.MAX_VALUE;
        }
        int n = startRowNumber = checkpoint == null ? this.start : (Integer)checkpoint;
        if (startRowNumber < this.start || startRowNumber > this.end || startRowNumber < 0) {
            throw SupportLogger.LOGGER.invalidStartPosition(startRowNumber, this.start, this.end);
        }
        if (this.headerless) {
            --startRowNumber;
            --this.end;
        }
        if (this.beanType == null) {
            throw SupportLogger.LOGGER.invalidReaderWriterProperty(null, null, "beanType");
        }
        InputStreamReader r = new InputStreamReader(this.getInputStream(true));
        this.delegateReader = List.class.isAssignableFrom(this.beanType) ? new FastForwardCsvListReader(r, this.getCsvPreference(), startRowNumber) : (Map.class.isAssignableFrom(this.beanType) ? new FastForwardCsvMapReader(r, this.getCsvPreference(), startRowNumber) : new FastForwardCsvBeanReader(r, this.getCsvPreference(), startRowNumber));
        SupportLogger.LOGGER.openingResource(this.resource, this.getClass());
        if (!this.headerless) {
            String[] header;
            try {
                header = this.delegateReader.getHeader(true);
            }
            catch (IOException e) {
                throw SupportLogger.LOGGER.failToReadCsvHeader(e, this.resource);
            }
            if (this.nameMapping == null) {
                this.nameMapping = header;
            }
        }
        this.cellProcessorInstances = this.getCellProcessors();
    }

    public void close() throws Exception {
        if (this.delegateReader != null) {
            SupportLogger.LOGGER.closingResource(this.resource, this.getClass());
            this.delegateReader.close();
            this.delegateReader = null;
        }
    }

    public Object readItem() throws Exception {
        if (this.delegateReader.getRowNumber() > this.end) {
            return null;
        }
        Object result = this.delegateReader instanceof ICsvBeanReader ? (this.cellProcessorInstances.length == 0 ? ((ICsvBeanReader)this.delegateReader).read(this.beanType, this.getNameMapping()) : ((ICsvBeanReader)this.delegateReader).read(this.beanType, this.getNameMapping(), this.cellProcessorInstances)) : (this.delegateReader instanceof ICsvListReader ? (this.cellProcessorInstances.length == 0 ? ((ICsvListReader)this.delegateReader).read() : ((ICsvListReader)this.delegateReader).read(this.cellProcessorInstances)) : (this.cellProcessorInstances.length == 0 ? ((ICsvMapReader)this.delegateReader).read(this.getNameMapping()) : ((ICsvMapReader)this.delegateReader).read(this.getNameMapping(), this.cellProcessorInstances)));
        return result;
    }

    public Integer checkpointInfo() throws Exception {
        return this.delegateReader.getRowNumber();
    }
}

