/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.vertx.shell;

import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.ext.shell.command.CommandProcess;
import org.jberet.vertx.shell.CommandBase;

@Name(value="count-job-instances")
@Summary(value="Count job instances")
public final class CountJobInstancesCommand
extends CommandBase {
    private String jobName;

    @Description(value="the name of the job whose job instances to count")
    @Option(required=true, longName="job-name", shortName="j")
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void process(CommandProcess process) {
        try {
            int count = jobOperator.getJobInstanceCount(this.jobName);
            process.write(String.format("%s job instances for job %s%n", count, this.jobName));
            process.end();
        }
        catch (Exception e) {
            CountJobInstancesCommand.failed(process, e);
        }
    }
}

