/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.vertx.shell;

import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.ext.shell.command.CommandProcess;
import javax.batch.runtime.JobExecution;
import org.jberet.vertx.shell.CommandBase;
import org.jberet.vertx.shell.GetStepExecutionCommand;

@Name(value="get-job-execution")
@Summary(value="Get job execution details")
public final class GetJobExecutionCommand
extends CommandBase {
    private long jobExecutionId;

    @Description(value="the job execution id")
    @Argument(index=0, argName="jobExecutionId")
    public void setJobExecutionId(long i) {
        this.jobExecutionId = i;
    }

    public void process(CommandProcess process) {
        try {
            JobExecution je = jobOperator.getJobExecution(this.jobExecutionId);
            process.write(GetStepExecutionCommand.format("execution id", this.jobExecutionId)).write(GetStepExecutionCommand.format("job name", je.getJobName())).write(GetStepExecutionCommand.format("batch status", je.getBatchStatus())).write(GetStepExecutionCommand.format("exit status", je.getExitStatus())).write(GetStepExecutionCommand.format("create time", je.getCreateTime())).write(GetStepExecutionCommand.format("start time", je.getStartTime())).write(GetStepExecutionCommand.format("update time", je.getLastUpdatedTime())).write(GetStepExecutionCommand.format("end time", je.getEndTime())).write(GetStepExecutionCommand.format("job params", je.getJobParameters()));
            process.end();
        }
        catch (Exception e) {
            GetJobExecutionCommand.failed(process, e);
        }
    }
}

