/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.vertx.shell;

import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.ext.shell.command.CommandProcess;
import java.util.List;
import javax.batch.runtime.JobInstance;
import org.jberet.vertx.shell.CommandBase;

@Name(value="list-job-instances")
@Summary(value="List job instances")
public final class ListJobInstancesCommand
extends CommandBase {
    private String jobName;
    private int start;
    private int count = 10;

    @Description(value="the name of the job")
    @Option(required=true, longName="job-name", shortName="j")
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Description(value="the start position within all matching job instances (0-based)")
    @Option(longName="start", shortName="s")
    public void setStart(int start) {
        this.start = start;
    }

    @Description(value="the number of job instances to return, defaults to 10")
    @Option(longName="count", shortName="c")
    public void setCount(int count) {
        this.count = count;
    }

    public void process(CommandProcess process) {
        try {
            List jobInstances = jobOperator.getJobInstances(this.jobName, this.start, this.count);
            process.write(String.format("Job instances for job %s:%n", this.jobName));
            for (JobInstance jobInstance : jobInstances) {
                process.write(String.format("%s%n", jobInstance.getInstanceId()));
            }
            process.end();
        }
        catch (Exception e) {
            ListJobInstancesCommand.failed(process, e);
        }
    }
}

