/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.wildfly.cluster.ejb;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.jberet.spi.PartitionInfo;
import org.jberet.wildfly.cluster.ejb.PartitionSingletonBean;
import org.jberet.wildfly.cluster.jms._private.ClusterJmsMessages;

@MessageDriven(name="PartitionMessageBean", activationConfig={@ActivationConfigProperty(propertyName="destinationLookup", propertyValue="jms/partitionQueue"), @ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="type = 'P'")})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class PartitionMessageBean
implements MessageListener {
    @Inject
    private PartitionSingletonBean partitionSingletonBean;

    public void onMessage(Message message) {
        PartitionInfo partitionInfo;
        try {
            partitionInfo = (PartitionInfo)message.getBody(PartitionInfo.class);
        }
        catch (JMSException e) {
            throw ClusterJmsMessages.MESSAGES.failedInJms((Throwable)e);
        }
        this.partitionSingletonBean.runPartition(partitionInfo);
    }
}

