/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.wildfly.cluster.infinispan;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.jberet.job.model.Step;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobStopNotificationListener;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.spi.PartitionHandler;
import org.jberet.spi.PartitionInfo;
import org.jberet.wildfly.cluster.infinispan.CacheKey;
import org.jberet.wildfly.cluster.infinispan.InfinispanPartitionResource;
import org.jberet.wildfly.cluster.infinispan.PartitionCallable;
import org.jberet.wildfly.cluster.infinispan.PartitionResultFilter;
import org.jberet.wildfly.cluster.infinispan.PartitionResultListener;
import org.jberet.wildfly.cluster.infinispan.StopRequest;
import org.jberet.wildfly.cluster.infinispan._private.ClusterInfinispanLogger;

public class InfinispanPartitionHandler
implements PartitionHandler,
JobStopNotificationListener {
    BlockingQueue<Boolean> completedPartitionThreads;
    BlockingQueue<Serializable> collectorDataQueue;
    private final InfinispanPartitionResource infinispanPartitionResource = new InfinispanPartitionResource();
    private final Cache<CacheKey, Object> cache = this.infinispanPartitionResource.getCache();
    private final PartitionResultListener partitionResultListener;

    public InfinispanPartitionHandler(StepContextImpl stepContext) {
        long stepExecutionId = stepContext.getStepExecutionId();
        this.partitionResultListener = new PartitionResultListener(this, stepContext);
        PartitionResultFilter filter = new PartitionResultFilter(stepExecutionId);
        this.cache.addFilteredListener((Object)this.partitionResultListener, (CacheEventFilter)filter, null, InfinispanPartitionResource.cacheModifiedType);
    }

    public void setResourceTracker(BlockingQueue<Boolean> completedPartitionThreads) {
        this.completedPartitionThreads = completedPartitionThreads;
    }

    public void setCollectorDataQueue(BlockingQueue<Serializable> collectorDataQueue) {
        this.collectorDataQueue = collectorDataQueue;
    }

    public void submitPartitionTask(StepContextImpl partitionStepContext, int currentIndex, int numOfPartitions) throws Exception {
        Step step1 = partitionStepContext.getStep();
        PartitionExecutionImpl partitionExecution = (PartitionExecutionImpl)partitionStepContext.getStepExecution();
        JobExecutionImpl jobExecution = partitionStepContext.getJobContext().getJobExecution();
        PartitionInfo partitionInfo = new PartitionInfo(partitionExecution, step1, jobExecution);
        CacheKey cacheKey = new CacheKey(jobExecution.getExecutionId(), partitionExecution.getStepExecutionId(), partitionExecution.getPartitionId());
        this.cache.put((Object)cacheKey, (Object)partitionInfo);
        if (currentIndex == numOfPartitions - 1) {
            Object[] keys = (CacheKey[])this.cache.keySet().toArray((Object[])new CacheKey[numOfPartitions]);
            DefaultExecutorService executorService = new DefaultExecutorService(this.cache);
            PartitionCallable partitionCallable = new PartitionCallable();
            executorService.submit((Callable)((Object)partitionCallable), keys);
            ClusterInfinispanLogger.LOGGER.info("## submitted " + this.cache.size() + " tasks, " + partitionCallable);
        }
    }

    public void stopRequested(long jobExecutionId) {
        AdvancedCache advancedCache = this.cache.getAdvancedCache();
        AdvancedCache cacheLocal = advancedCache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD});
        for (CacheKey cacheKey : cacheLocal.keySet()) {
            Object val;
            if (cacheKey.getJobExecutionId() != jobExecutionId || (val = cacheLocal.get((Object)cacheKey)) instanceof StopRequest) continue;
            advancedCache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace((Object)cacheKey, (Object)StopRequest.getInstance());
        }
    }

    public void close(StepContextImpl stepContext) {
        this.infinispanPartitionResource.close();
        this.cache.removeListener((Object)this.partitionResultListener);
    }
}

