/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.wildfly.cluster.infinispan;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchRuntime;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.Cache;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.jberet.operations.AbstractJobOperator;
import org.jberet.operations.DelegatingJobOperator;
import org.jberet.wildfly.cluster.infinispan.CacheKey;
import org.jberet.wildfly.cluster.infinispan._private.ClusterInfinispanLogger;
import org.jberet.wildfly.cluster.infinispan._private.ClusterInfinispanMessages;

public final class InfinispanPartitionResource {
    public static final String CACHE_CONTAINER_NAME = "infinispan/container/jberet";
    public static final String CACHE_NAME = "infinispan/cache/web/jberet";
    static final Set<Class<? extends Annotation>> cacheModifiedType = Stream.of(CacheEntryModified.class).collect(Collectors.toSet());
    private final Context namingContext;

    public InfinispanPartitionResource() {
        try {
            this.namingContext = new InitialContext();
        }
        catch (NamingException e) {
            throw ClusterInfinispanMessages.MESSAGES.failedToNewNamingContext(e);
        }
    }

    public <T> T lookUp(String name) {
        String s = name.startsWith("java:") ? name : "java:comp/env/" + name;
        try {
            Object result = this.namingContext.lookup(s);
            ClusterInfinispanLogger.LOGGER.lookupResource(s, result);
            return (T)result;
        }
        catch (NamingException e) {
            throw ClusterInfinispanMessages.MESSAGES.failedToLookup(e, s);
        }
    }

    public Cache<CacheKey, Object> getCache() {
        return (Cache)this.lookUp(CACHE_NAME);
    }

    public void close() {
        if (this.namingContext != null) {
            try {
                this.namingContext.close();
            }
            catch (NamingException e) {
                ClusterInfinispanLogger.LOGGER.problemClosingResource(e);
            }
        }
    }

    public static AbstractJobOperator getJobOperator() {
        JobOperator delegate;
        JobOperator operator = BatchRuntime.getJobOperator();
        AbstractJobOperator jobOperator = null;
        if (operator instanceof DelegatingJobOperator && (delegate = ((DelegatingJobOperator)operator).getDelegate()) instanceof AbstractJobOperator) {
            jobOperator = (AbstractJobOperator)delegate;
        }
        if (jobOperator == null) {
            throw ClusterInfinispanMessages.MESSAGES.failedToGetJobOperator();
        }
        return jobOperator;
    }
}

