/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.wildfly.cluster.infinispan;

import java.io.Serializable;
import org.infinispan.Cache;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.spi.PartitionWorker;
import org.jberet.wildfly.cluster.infinispan.CacheKey;
import org.jberet.wildfly.cluster.infinispan.PartitionStopListener;
import org.jberet.wildfly.cluster.infinispan._private.ClusterInfinispanLogger;

public class InfinispanPartitionWorker
implements PartitionWorker {
    private final Cache<CacheKey, Object> cache;
    private final CacheKey cacheKey;
    private final PartitionStopListener partitionStopListener;

    public InfinispanPartitionWorker(Cache<CacheKey, Object> cache, CacheKey cacheKey, PartitionStopListener partitionStopListener) {
        this.cache = cache;
        this.cacheKey = cacheKey;
        this.partitionStopListener = partitionStopListener;
    }

    public void reportData(Serializable data, AbstractStepExecution partitionExecution) throws Exception {
        long stepExecutionId = partitionExecution.getStepExecutionId();
        this.cache.put((Object)this.cacheKey, (Object)data);
        ClusterInfinispanLogger.LOGGER.sendCollectorData(stepExecutionId, ((PartitionExecutionImpl)partitionExecution).getPartitionId(), data);
    }

    public void partitionDone(AbstractStepExecution partitionExecution) throws Exception {
        this.reportData((Serializable)partitionExecution, partitionExecution);
        this.cache.removeListener((Object)this.partitionStopListener);
    }
}

