/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.wildfly.cluster.infinispan;

import java.io.Serializable;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.jberet.creation.ArtifactFactoryWrapper;
import org.jberet.job.model.Chunk;
import org.jberet.job.model.Step;
import org.jberet.operations.AbstractJobOperator;
import org.jberet.repository.JobRepository;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.context.AbstractContext;
import org.jberet.runtime.context.JobContextImpl;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.runner.BatchletRunner;
import org.jberet.runtime.runner.ChunkRunner;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.JobTask;
import org.jberet.spi.PartitionInfo;
import org.jberet.spi.PartitionWorker;
import org.jberet.wildfly.cluster.infinispan.CacheKey;
import org.jberet.wildfly.cluster.infinispan.InfinispanPartitionResource;
import org.jberet.wildfly.cluster.infinispan.InfinispanPartitionWorker;
import org.jberet.wildfly.cluster.infinispan.PartitionStopListener;
import org.jberet.wildfly.cluster.infinispan.StopRequest;
import org.jberet.wildfly.cluster.infinispan._private.ClusterInfinispanLogger;

public class PartitionCallable
implements DistributedCallable<CacheKey, Object, Void>,
Serializable {
    private static final long serialVersionUID = -5054226353703356512L;
    private transient Cache<CacheKey, Object> cache;
    private transient Set<CacheKey> inputKeys;

    public void setEnvironment(Cache<CacheKey, Object> cache, Set<CacheKey> inputKeys) {
        ClusterInfinispanLogger.LOGGER.info("## in setEnvironment, selected keys: " + inputKeys.toString() + ", cache size: " + cache.size());
        this.cache = cache;
        this.inputKeys = inputKeys;
    }

    public Void call() throws Exception {
        ClusterInfinispanLogger.LOGGER.info("## about to get jobOperator");
        AbstractJobOperator jobOperator = InfinispanPartitionResource.getJobOperator();
        BatchEnvironment batchEnvironment = jobOperator.getBatchEnvironment();
        JobRepository jobRepository = jobOperator.getJobRepository();
        ArtifactFactoryWrapper artifactFactory = new ArtifactFactoryWrapper(batchEnvironment.getArtifactFactory());
        ClusterInfinispanLogger.LOGGER.info("## got jobOperator: " + jobOperator + "inputKeys: " + this.inputKeys);
        AdvancedCache cacheLocal = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD});
        for (final CacheKey k : this.inputKeys) {
            Object val = cacheLocal.get((Object)k);
            if (!(val instanceof PartitionInfo)) continue;
            PartitionInfo partitionInfo = (PartitionInfo)val;
            JobExecutionImpl jobExecution = partitionInfo.getJobExecution();
            Step step = partitionInfo.getStep();
            PartitionExecutionImpl partitionExecution = partitionInfo.getPartitionExecution();
            PartitionStopListener partitionStopListener = new PartitionStopListener(partitionInfo);
            this.cache.addFilteredListener((Object)partitionStopListener, (CacheEventFilter)new CacheEventFilter<CacheKey, Object>(){

                public boolean accept(CacheKey key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
                    return newValue instanceof StopRequest && key.equals(k);
                }
            }, null, InfinispanPartitionResource.cacheModifiedType);
            ClusterInfinispanLogger.LOGGER.receivedPartitionInfo(partitionInfo);
            JobContextImpl jobContext = new JobContextImpl(jobExecution, null, (ArtifactFactory)artifactFactory, jobRepository, batchEnvironment);
            InfinispanPartitionWorker partitionWorker = new InfinispanPartitionWorker(this.cache, k, partitionStopListener);
            AbstractContext[] outerContext = new AbstractContext[]{jobContext};
            StepContextImpl stepContext = new StepContextImpl(step, (AbstractStepExecution)partitionExecution, outerContext);
            Chunk chunk = step.getChunk();
            Object runner = chunk == null ? new BatchletRunner(stepContext, null, step.getBatchlet(), (PartitionWorker)partitionWorker) : new ChunkRunner(stepContext, null, chunk, null, (PartitionWorker)partitionWorker);
            batchEnvironment.submitTask((JobTask)runner);
        }
        return null;
    }
}

