/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.wildfly.cluster.infinispan;

import java.io.Serializable;
import java.util.List;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.wildfly.cluster.infinispan.InfinispanPartitionHandler;
import org.jberet.wildfly.cluster.infinispan._private.ClusterInfinispanLogger;
import org.jboss.logging.Logger;

@Listener(clustered=true)
public class PartitionResultListener {
    private final InfinispanPartitionHandler infinispanPartitionHandler;
    private final StepContextImpl stepContext;

    public PartitionResultListener(InfinispanPartitionHandler infinispanPartitionHandler, StepContextImpl stepContext) {
        this.infinispanPartitionHandler = infinispanPartitionHandler;
        this.stepContext = stepContext;
    }

    @CacheEntryModified
    public void entryModified(CacheEntryModifiedEvent event) {
        Object key = event.getKey();
        Object value = event.getValue();
        ClusterInfinispanLogger.LOGGER.logf(Logger.Level.INFO, "## in entryModified key=%s, value=%s", key, value);
        Serializable partitionCollectorData = (Serializable)value;
        if (partitionCollectorData instanceof PartitionExecutionImpl) {
            if (this.infinispanPartitionHandler.completedPartitionThreads != null) {
                this.infinispanPartitionHandler.completedPartitionThreads.offer(Boolean.TRUE);
            }
            PartitionExecutionImpl partitionExecution = (PartitionExecutionImpl)partitionCollectorData;
            int partitionId = partitionExecution.getPartitionId();
            ClusterInfinispanLogger.LOGGER.receivedPartitionResult(this.stepContext.getJobContext().getExecutionId(), this.stepContext.getStepExecutionId(), partitionId, partitionExecution.getBatchStatus());
            List partitionExecutions = this.stepContext.getStepExecution().getPartitionExecutions();
            for (int i = 0; i < partitionExecutions.size(); ++i) {
                if (((PartitionExecutionImpl)partitionExecutions.get(i)).getPartitionId() != partitionId) continue;
                partitionExecutions.remove(i);
                partitionExecutions.add(partitionExecution);
            }
        }
        try {
            this.infinispanPartitionHandler.collectorDataQueue.put(partitionCollectorData);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

