/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.wildfly.cluster.infinispan;

import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.spi.PartitionInfo;
import org.jberet.wildfly.cluster.infinispan._private.ClusterInfinispanLogger;

@Listener(clustered=false)
public class PartitionStopListener {
    private final PartitionInfo partitionInfo;

    public PartitionStopListener(PartitionInfo partitionInfo) {
        this.partitionInfo = partitionInfo;
    }

    @CacheEntryModified
    public void entryModified(CacheEntryModifiedEvent event) {
        Object key = event.getKey();
        Object value = event.getValue();
        Cache cache = event.getCache();
        JobExecutionImpl jobExecution = this.partitionInfo.getJobExecution();
        PartitionExecutionImpl partitionExecution = this.partitionInfo.getPartitionExecution();
        ClusterInfinispanLogger.LOGGER.receivedStopRequest(jobExecution.getExecutionId(), partitionExecution.getStepName(), partitionExecution.getStepExecutionId(), partitionExecution.getPartitionId());
        jobExecution.stop();
    }
}

