/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.samples.wildfly.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class StockTrade
implements Serializable {
    private static final long serialVersionUID = -55209987994863611L;
    @JsonProperty(value="Date")
    Date date;
    @JsonProperty(value="Time")
    String time;
    @JsonProperty(value="Open")
    double open;
    @JsonProperty(value="High")
    double high;
    @JsonProperty(value="Low")
    double low;
    @JsonProperty(value="Close")
    double close;
    @JsonProperty(value="Volume")
    double volume;

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public double getOpen() {
        return this.open;
    }

    public void setOpen(double open) {
        this.open = open;
    }

    public double getHigh() {
        return this.high;
    }

    public void setHigh(double high) {
        this.high = high;
    }

    public double getLow() {
        return this.low;
    }

    public void setLow(double low) {
        this.low = low;
    }

    public double getClose() {
        return this.close;
    }

    public void setClose(double close) {
        this.close = close;
    }

    public double getVolume() {
        return this.volume;
    }

    public void setVolume(double volume) {
        this.volume = volume;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StockTrade{");
        sb.append("date=").append(this.date);
        sb.append(", time='").append(this.time).append('\'');
        sb.append(", open=").append(this.open);
        sb.append(", high=").append(this.high);
        sb.append(", low=").append(this.low);
        sb.append(", close=").append(this.close);
        sb.append(", volume=").append(this.volume);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StockTrade)) {
            return false;
        }
        StockTrade that = (StockTrade)o;
        if (Double.compare(that.close, this.close) != 0) {
            return false;
        }
        if (Double.compare(that.high, this.high) != 0) {
            return false;
        }
        if (Double.compare(that.low, this.low) != 0) {
            return false;
        }
        if (Double.compare(that.open, this.open) != 0) {
            return false;
        }
        if (Double.compare(that.volume, this.volume) != 0) {
            return false;
        }
        if (!this.date.equals(that.date)) {
            return false;
        }
        return this.time.equals(that.time);
    }

    public int hashCode() {
        int result = this.date.hashCode();
        result = 31 * result + this.time.hashCode();
        long temp = Double.doubleToLongBits(this.open);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.high);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.low);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.close);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.volume);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

